; Compiled with: PIC Simulator IDE v7.37
; Microcontroller model: PIC16F628A
; Clock frequency: 4.0MHz
;
	R0L EQU 0x020
	R0H EQU 0x021
	R4L EQU 0x028
	R4H EQU 0x029
	R0HL EQU 0x020
	R4HL EQU 0x028
	LONG_0 EQU 0x02A
	LONG_1 EQU 0x02B
	LONG_2 EQU 0x02C
	LONG_3 EQU 0x02D
	LONG2_0 EQU 0x02E
	LONG2_1 EQU 0x02F
	LONG2_2 EQU 0x030
	LONG2_3 EQU 0x031
	LONG1 EQU 0x02A
	LONG2 EQU 0x02E
	W_TEMP EQU 0x07F
	STATUS_TEMP EQU 0x07E
;       The value of 'time' (global) is 40
;       The address of 'halltime1' (byte) (global) is 0x022
;       The address of 'halltime2' (byte) (global) is 0x023
;       The address of 'halltime3' (byte) (global) is 0x024
;       The address of 'halltime4' (byte) (global) is 0x025
;       The address of 'halltime5' (byte) (global) is 0x026
;       The address of 'halltime6' (byte) (global) is 0x027
;       The address of 'halltime7' (byte) (global) is 0x032
;       The address of 'halltime8' (byte) (global) is 0x033
;       The address of 'clock' (byte) (global) is 0x034
;       The address of 'hall1' (bit) (global) is 0x005,1
;       The address of 'hall2' (bit) (global) is 0x005,2
;       The address of 'hall3' (bit) (global) is 0x005,0
;       The address of 'hall4' (bit) (global) is 0x005,3
;       The address of 'hall5' (bit) (global) is 0x005,7
;       The address of 'hall6' (bit) (global) is 0x005,4
;       The address of 'hall7' (bit) (global) is 0x005,6
;       The address of 'hall8' (bit) (global) is 0x005,5
;       The address of 'fb1' (bit) (global) is 0x006,4
;       The address of 'fb2' (bit) (global) is 0x006,5
;       The address of 'fb3' (bit) (global) is 0x006,6
;       The address of 'fb4' (bit) (global) is 0x006,7
;       The address of 'fb5' (bit) (global) is 0x006,3
;       The address of 'fb6' (bit) (global) is 0x006,2
;       The address of 'fb7' (bit) (global) is 0x006,1
;       The address of 'fb8' (bit) (global) is 0x006,0
	ORG 0x0000
	BCF PCLATH,4
	BCF PCLATH,3
	GOTO L0002
	ORG 0x0004
	MOVWF W_TEMP
	SWAPF STATUS,W
	CLRF STATUS
	MOVWF STATUS_TEMP
	CALL L0003
	SWAPF STATUS_TEMP,W
	MOVWF STATUS
	SWAPF W_TEMP,F
	SWAPF W_TEMP,W
	RETFIE
; User code start
L0002:
; 1: 'program GCA173 V.5
; 2: 'pulse extender for halldiodes
; 3: 'all outputs are normal high
; 4: 'Output will be low if according input is low for more than 2 mSecs.
; 5: 'output will be high after 200 mSec and input = high.
; 6: '22 march 2016  Definition Freqyency added.
; 7: '13 aug 2016 phg V1.5  startup changed.
; 8: Define CONF_WORD = 0x3f50
; 9: Define CLOCK_FREQUENCY = 4
; 10: CMCON = 7
	MOVLW 0x07
	MOVWF CMCON
; 11: TRISA = 255
	MOVLW 0xFF
	BSF STATUS,RP0
	MOVWF TRISA
; 12: TRISB = 0
	CLRF TRISB
	BCF STATUS,RP0
; 13: PORTB = 255
	MOVLW 0xFF
	MOVWF PORTB
; 14: 
; 15: 
; 16: Symbol hall1 = RA1
; 17: Symbol hall2 = RA2
; 18: Symbol hall3 = RA0
; 19: Symbol hall4 = RA3
; 20: Symbol hall5 = RA7
; 21: Symbol hall6 = RA4
; 22: Symbol hall7 = RA6
; 23: Symbol hall8 = RA5
; 24: Symbol fb1 = RB4
; 25: Symbol fb2 = RB5
; 26: Symbol fb3 = RB6
; 27: Symbol fb4 = RB7
; 28: Symbol fb5 = RB3
; 29: Symbol fb6 = RB2
; 30: Symbol fb7 = RB1
; 31: Symbol fb8 = RB0
; 32: Dim halltime1 As Byte
	CLRF 0x022
; 33: Dim halltime2 As Byte
	CLRF 0x023
; 34: Dim halltime3 As Byte
	CLRF 0x024
; 35: Dim halltime4 As Byte
	CLRF 0x025
; 36: Dim halltime5 As Byte
	CLRF 0x026
; 37: Dim halltime6 As Byte
	CLRF 0x027
; 38: Dim halltime7 As Byte
	CLRF 0x032
; 39: Dim halltime8 As Byte
	CLRF 0x033
; 40: Dim clock As Byte
	CLRF 0x034
; 41: Const time = 40  'interrupt  every 250 uSec , timing 80 mSec after hall(x) becomes high
; 42: OPTION_REG.T0CS = 0  'Bit 5 TMR0 clock source Select Bit: 0 = internal clock(clko) / 1 = transition On t0cki pin
	BSF STATUS,RP0
	BCF OPTION_REG,5
; 43: OPTION_REG.T0SE = 0  '; ; Bit 4 TMR0 source edge Select Bit: 0 = Low / High / 1 = High / Low
	BCF OPTION_REG,4
; 44: OPTION_REG.PSA = 0  '; ; Bit 3 prescaler assignment Bit: 0 = prescaler is assigned To the wdt
	BCF OPTION_REG,3
; 45: OPTION_REG.PS2 = 0  '; ; bits 2 - 0 PS2: PS0: prescaler rate Select bits
	BCF OPTION_REG,2
; 46: OPTION_REG.PS1 = 0  ';
	BCF OPTION_REG,1
; 47: OPTION_REG.PS0 = 0  ';
	BCF OPTION_REG,0
	BCF STATUS,RP0
; 48: TMR0 = 6  '; ; preset For timer register
	MOVLW 0x06
	MOVWF TMR0
; 49: INTCON.T0IE = 1  'enable Timer0 interrupts
	BSF INTCON,5
; 50: INTCON.T0IF = 0  'enable new TMR0 interrupts
	BCF INTCON,2
; 51: INTCON.GIE = True  'enable all un-masked interrupts
	BSF INTCON,7
; 52: OPTION_REG.T0CS = False  'set Timer0 clock source to internal instruction cycle clock
	BSF STATUS,RP0
	BCF OPTION_REG,5
	BCF STATUS,RP0
; 53: WaitMs 2000
	MOVLW 0xD0
	MOVWF R0L
	MOVLW 0x07
	MOVWF R0H
	CALL W001
; 54: fb1 = 0
	BCF PORTB,4
; 55: WaitMs 100
	MOVLW 0x0E
	MOVWF R4L
	MOVLW 0x27
	MOVWF R4H
	CALL DL02
; 56: fb1 = 1
	BSF PORTB,4
; 57: fb2 = 0
	BCF PORTB,5
; 58: WaitMs 100
	MOVLW 0x0E
	MOVWF R4L
	MOVLW 0x27
	MOVWF R4H
	CALL DL02
; 59: fb2 = 1
	BSF PORTB,5
; 60: fb3 = 0
	BCF PORTB,6
; 61: WaitMs 100
	MOVLW 0x0E
	MOVWF R4L
	MOVLW 0x27
	MOVWF R4H
	CALL DL02
; 62: fb3 = 1
	BSF PORTB,6
; 63: fb4 = 0
	BCF PORTB,7
; 64: WaitMs 100
	MOVLW 0x0E
	MOVWF R4L
	MOVLW 0x27
	MOVWF R4H
	CALL DL02
; 65: fb4 = 1
	BSF PORTB,7
; 66: fb5 = 0
	BCF PORTB,3
; 67: WaitMs 100
	MOVLW 0x0E
	MOVWF R4L
	MOVLW 0x27
	MOVWF R4H
	CALL DL02
; 68: fb5 = 1
	BSF PORTB,3
; 69: fb6 = 0
	BCF PORTB,2
; 70: WaitMs 100
	MOVLW 0x0E
	MOVWF R4L
	MOVLW 0x27
	MOVWF R4H
	CALL DL02
; 71: fb6 = 1
	BSF PORTB,2
; 72: fb7 = 0
	BCF PORTB,1
; 73: WaitMs 100
	MOVLW 0x0E
	MOVWF R4L
	MOVLW 0x27
	MOVWF R4H
	CALL DL02
; 74: fb8 = 1
	BSF PORTB,0
; 75: WaitMs 1000
	MOVLW 0xE8
	MOVWF R0L
	MOVLW 0x03
	MOVWF R0H
	CALL W001
; 76: main:
L0001:
; 77: 'hallsensor 1
; 78: If hall1 = 0 Then
	BTFSC 0x005,1
	GOTO L0004
; 79: halltime1 = 8
	MOVLW 0x08
	MOVWF 0x022
; 80: fb1 = 0
	BCF PORTB,4
; 81: Else
	GOTO L0005
L0004:
; 82: If halltime1 = 0 Then
	MOVF 0x022,W
	SUBLW 0x00
	BTFSS STATUS,Z
	GOTO L0006
; 83: fb1 = 1
	BSF PORTB,4
; 84: Endif
L0006:
; 85: Endif
L0005:
; 86: 
; 87: 'hallsensor 2
; 88: If hall2 = 0 Then
	BTFSC 0x005,2
	GOTO L0007
; 89: halltime2 = 8
	MOVLW 0x08
	MOVWF 0x023
; 90: fb2 = 0
	BCF PORTB,5
; 91: Else
	GOTO L0008
L0007:
; 92: If halltime2 = 0 Then
	MOVF 0x023,W
	SUBLW 0x00
	BTFSS STATUS,Z
	GOTO L0009
; 93: fb2 = 1
	BSF PORTB,5
; 94: Endif
L0009:
; 95: Endif
L0008:
; 96: 
; 97: 'hallsensor 3
; 98: If hall3 = 0 Then
	BTFSC 0x005,0
	GOTO L0010
; 99: halltime3 = 8
	MOVLW 0x08
	MOVWF 0x024
; 100: fb3 = 0
	BCF PORTB,6
; 101: Else
	GOTO L0011
L0010:
; 102: If halltime3 = 0 Then
	MOVF 0x024,W
	SUBLW 0x00
	BTFSS STATUS,Z
	GOTO L0012
; 103: fb3 = 1
	BSF PORTB,6
; 104: Endif
L0012:
; 105: Endif
L0011:
; 106: 'hallsensor 4
; 107: If hall4 = 0 Then
	BTFSC 0x005,3
	GOTO L0013
; 108: halltime4 = 8
	MOVLW 0x08
	MOVWF 0x025
; 109: fb4 = 0
	BCF PORTB,7
; 110: Else
	GOTO L0014
L0013:
; 111: If halltime4 = 0 Then
	MOVF 0x025,W
	SUBLW 0x00
	BTFSS STATUS,Z
	GOTO L0015
; 112: fb4 = 1
	BSF PORTB,7
; 113: Endif
L0015:
; 114: Endif
L0014:
; 115: 
; 116: 'hallsensor 5
; 117: If hall5 = 0 Then
	BTFSC 0x005,7
	GOTO L0016
; 118: halltime5 = 8
	MOVLW 0x08
	MOVWF 0x026
; 119: fb5 = 0
	BCF PORTB,3
; 120: Else
	GOTO L0017
L0016:
; 121: If halltime5 = 0 Then
	MOVF 0x026,W
	SUBLW 0x00
	BTFSS STATUS,Z
	GOTO L0018
; 122: fb5 = 1
	BSF PORTB,3
; 123: Endif
L0018:
; 124: Endif
L0017:
; 125: 
; 126: 'hallsensor 6
; 127: If hall6 = 0 Then
	BTFSC 0x005,4
	GOTO L0019
; 128: halltime6 = 8
	MOVLW 0x08
	MOVWF 0x027
; 129: fb6 = 0
	BCF PORTB,2
; 130: Else
	GOTO L0020
L0019:
; 131: If halltime6 = 0 Then
	MOVF 0x027,W
	SUBLW 0x00
	BTFSS STATUS,Z
	GOTO L0021
; 132: fb6 = 1
	BSF PORTB,2
; 133: Endif
L0021:
; 134: Endif
L0020:
; 135: 
; 136: 'hallsensor 7
; 137: If hall7 = 0 Then
	BTFSC 0x005,6
	GOTO L0022
; 138: halltime7 = 8
	MOVLW 0x08
	MOVWF 0x032
; 139: fb7 = 0
	BCF PORTB,1
; 140: Else
	GOTO L0023
L0022:
; 141: If halltime7 = 0 Then
	MOVF 0x032,W
	SUBLW 0x00
	BTFSS STATUS,Z
	GOTO L0024
; 142: fb7 = 1
	BSF PORTB,1
; 143: Endif
L0024:
; 144: Endif
L0023:
; 145: 
; 146: 'hallsensor 8
; 147: If hall8 = 0 Then
	BTFSC 0x005,5
	GOTO L0025
; 148: halltime8 = 8
	MOVLW 0x08
	MOVWF 0x033
; 149: fb8 = 0
	BCF PORTB,0
; 150: Else
	GOTO L0026
L0025:
; 151: If halltime8 = 0 Then
	MOVF 0x033,W
	SUBLW 0x00
	BTFSS STATUS,Z
	GOTO L0027
; 152: fb8 = 1
	BSF PORTB,0
; 153: Endif
L0027:
; 154: Endif
L0026:
; 155: If clock = time Then
	MOVF 0x034,W
	SUBLW 0x28
	BTFSS STATUS,Z
	GOTO L0028
; 156: clock = 0
	CLRF 0x034
; 157: If halltime1 > 0 Then
	MOVF 0x022,W
	SUBLW 0x00
	BTFSC STATUS,C
	GOTO L0029
; 158: halltime1 = halltime1 - 1
	MOVLW 0x01
	SUBWF 0x022,W
	MOVWF 0x022
; 159: Else
	GOTO L0030
L0029:
; 160: fb1 = 1
	BSF PORTB,4
; 161: Endif
L0030:
; 162: If halltime2 > 0 Then
	MOVF 0x023,W
	SUBLW 0x00
	BTFSC STATUS,C
	GOTO L0031
; 163: halltime2 = halltime2 - 1
	MOVLW 0x01
	SUBWF 0x023,W
	MOVWF 0x023
; 164: Else
	GOTO L0032
L0031:
; 165: fb2 = 1
	BSF PORTB,5
; 166: Endif
L0032:
; 167: If halltime3 > 0 Then
	MOVF 0x024,W
	SUBLW 0x00
	BTFSC STATUS,C
	GOTO L0033
; 168: halltime3 = halltime3 - 1
	MOVLW 0x01
	SUBWF 0x024,W
	MOVWF 0x024
; 169: Else
	GOTO L0034
L0033:
; 170: fb3 = 1
	BSF PORTB,6
; 171: Endif
L0034:
; 172: If halltime4 > 0 Then
	MOVF 0x025,W
	SUBLW 0x00
	BTFSC STATUS,C
	GOTO L0035
; 173: halltime4 = halltime4 - 1
	MOVLW 0x01
	SUBWF 0x025,W
	MOVWF 0x025
; 174: Else
	GOTO L0036
L0035:
; 175: fb4 = 1
	BSF PORTB,7
; 176: Endif
L0036:
; 177: If halltime5 > 0 Then
	MOVF 0x026,W
	SUBLW 0x00
	BTFSC STATUS,C
	GOTO L0037
; 178: halltime5 = halltime5 - 1
	MOVLW 0x01
	SUBWF 0x026,W
	MOVWF 0x026
; 179: Else
	GOTO L0038
L0037:
; 180: fb5 = 1
	BSF PORTB,3
; 181: Endif
L0038:
; 182: If halltime6 > 0 Then
	MOVF 0x027,W
	SUBLW 0x00
	BTFSC STATUS,C
	GOTO L0039
; 183: halltime6 = halltime6 - 1
	MOVLW 0x01
	SUBWF 0x027,W
	MOVWF 0x027
; 184: Else
	GOTO L0040
L0039:
; 185: fb6 = 1
	BSF PORTB,2
; 186: Endif
L0040:
; 187: If halltime7 > 0 Then
	MOVF 0x032,W
	SUBLW 0x00
	BTFSC STATUS,C
	GOTO L0041
; 188: halltime7 = halltime7 - 1
	MOVLW 0x01
	SUBWF 0x032,W
	MOVWF 0x032
; 189: Else
	GOTO L0042
L0041:
; 190: fb7 = 1
	BSF PORTB,1
; 191: Endif
L0042:
; 192: If halltime8 > 0 Then
	MOVF 0x033,W
	SUBLW 0x00
	BTFSC STATUS,C
	GOTO L0043
; 193: halltime8 = halltime8 - 1
	MOVLW 0x01
	SUBWF 0x033,W
	MOVWF 0x033
; 194: Else
	GOTO L0044
L0043:
; 195: fb8 = 1
	BSF PORTB,0
; 196: Endif
L0044:
; 197: Endif
L0028:
; 198: Goto main
	GOTO L0001
; 199: 
; 200: End
L0045:	GOTO L0045
; 201: On Interrupt
L0003:
; 202: clock = clock + 1
	MOVF 0x034,W
	ADDLW 0x01
	MOVWF 0x034
; 203: INTCON.T0IF = 0  'enable new TMR0 interrupts
	BCF INTCON,2
; 204: Resume
	RETURN
; End of user code
L0046:	GOTO L0046
;
;
; Delay Routine Byte
; minimal routine execution time: 8s
; routine execution time step: 3s
; maximal routine execution time: 770s
DL01:
	DECFSZ R4L,F
	GOTO DL01
	RETURN
; Delay Routine Word
; minimal routine execution time: 15s
; routine execution time step: 10s
; maximal routine execution time: 655365s
DL02:
	MOVLW 0x01
	SUBWF R4L,F
	CLRW
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF R4H,F
	BTFSS STATUS,C
	RETURN
	GOTO DL02
; Waitms Routine
W001:	MOVLW 0x01
	SUBWF R0L,F
	CLRW
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF R0H,F
	BTFSS STATUS,C
	RETURN
	MOVLW 0x61
	MOVWF R4L
	MOVLW 0x00
	MOVWF R4H
	CALL DL02
	GOTO W001
;
;
;
;
; Configuration settings
	ORG 0x2007
	DW 0x3F50
; End of listing
	END
