; Compiled with: OshonSoft PIC16 Basic Compiler v1.84
; Microcontroller model: PIC12F1840
; Clock frequency: 32.0MHz
;
	R0L EQU 0x020
	R0H EQU 0x021
	R1L EQU 0x022
	R1H EQU 0x023
	R4L EQU 0x028
	R4H EQU 0x029
	R0HL EQU 0x020
	R1HL EQU 0x022
	R4HL EQU 0x028
	R1HL0HL EQU 0x020
;       The value of 'max_timing' (global) is 3500
;       The value of 'max_current_prog' (global) is 55
;       The value of 'puls_time' (global) is 60
;       The value of 'ADC_Sample_uS' (global) is 20
;       The value of 'ADC_Clk' (global) is 3
;       The address of 'time1' (word) (global) is 0x025
;       The address of 'time2' (word) (global) is 0x02A
;       The address of 'current_1' (word) (global) is 0x032
;       The address of 'current_2' (word) (global) is 0x02C
;       The address of 'max_current_1' (word) (global) is 0x02E
;       The address of 'max_current_2' (word) (global) is 0x030
;       The address of 'task' (byte) (global) is 0x024
;       The address of 'dummy' (byte) (global) is 0x027
;       The address of 'fb' (bit) (global) is 0x00C,5
;       The address of 'cursel' (bit) (global) is 0x00C,4
	ORG 0x0000
	MOVLP 0x00
	GOTO L0004
	ORG 0x0004
	RETFIE
; User code start
L0004:
; 1: Define CONFIG1 = 0x0f84
; 2: Define CONFIG2 = 0x1cff
; 3: 
; 4: 'program for current control and DCC feed-back
; 5: 'started : apr 13 2020
; 6: 'by Peter giling
; 7: TRISA = %00011111
	MOVLW 0x1F
	MOVLB 0x01
	MOVWF TRISA
; 8: 
; 9: ADCON1.ADFM = 1
	BSF ADCON1,7
; 10: ADCON1.ADPREF0 = 0
	BCF ADCON1,0
; 11: ADCON1.ADPREF1 = 0
	BCF ADCON1,1
; 12: ADCON1.ADCS2 = 0
	BCF ADCON1,6
; 13: ADCON1.ADCS1 = 0
	BCF ADCON1,5
; 14: ADCON1.ADCS0 = 0
	BCF ADCON1,4
; 15: ANSELA.ANSA4 = 0
	MOVLB 0x03
	BCF ANSELA,4
; 16: ANSELA.ANSA2 = 0
	BCF ANSELA,2
; 17: ANSELA.ANSA1 = 1
	BSF ANSELA,1
; 18: ANSELA.ANSA0 = 1
	BSF ANSELA,0
; 19: 
; 20: 'ADCON0.CHS0 = 1
; 21: 'ADCON0.CHS1 = 0
; 22: 'ADCON0.CHS2 = 0
; 23: 'ADCON0.CHS3 = 0
; 24: ADCON0.CHS4 = 0
	MOVLB 0x01
	BCF ADCON0,6
	MOVLB 0x00
; 25: Symbol fb = RA5
; 26: Symbol cursel = RA4
; 27: Dim time1 As Word  'count max current main track
	CLRF 0x025
	CLRF 0x026
; 28: Dim time2 As Word  'count max current progr. track
	CLRF 0x02A
	CLRF 0x02B
; 29: Dim current_1 As Word  '' main track
	CLRF 0x032
	CLRF 0x033
; 30: Dim current_2 As Word  'program track
	CLRF 0x02C
	CLRF 0x02D
; 31: Dim max_current_1 As Word  'max current for main track
	CLRF 0x02E
	CLRF 0x02F
; 32: Dim max_current_2 As Word  'max current for progr track
	CLRF 0x030
	CLRF 0x031
; 33: Dim task As Byte  'selectio : 0 = all off, 2 = programming mode, else = normal
	CLRF 0x024
; 34: Dim dummy As Byte
	CLRF 0x027
; 35: Const max_timing = 3500
; 36: Const max_current_prog = 55
; 37: Const puls_time = 60  'this is the feed-back pulse when reading cf's
; 38: max_current_1 = 100  '(r4 * 1 * 1024) / 5 ~~ 100   >>  R4 = 0,47 Ohm
	MOVLW 0x64
	MOVWF 0x02E
	CLRF 0x02F
; 39: If cursel = 0 Then
	BTFSC 0x00C,4
	GOTO L0005
; 40: max_current_1 = 300  '(r4 * 3,5 * 1024) / 5 = 336
	MOVLW 0x2C
	MOVWF 0x02E
	MOVLW 0x01
	MOVWF 0x02F
; 41: Endif
L0005:
; 42: max_current_2 = 900  '(r5 * 1 * 1024) / 5 = 963   >> R5 =4,7 Ohm
	MOVLW 0x84
	MOVWF 0x030
	MOVLW 0x03
	MOVWF 0x031
; 43: task = 0
	CLRF 0x024
; 44: dummy = 0
	CLRF 0x027
; 45: Main:
L0001:
; 46: While dummy = 0
L0006:
	MOVF 0x027,W
	SUBLW 0x00
	BTFSS STATUS,Z
	GOTO L0007
; 47: task.0 = RA2
	BCF 0x024,0
	BTFSC PORTA,2
	BSF 0x024,0
; 48: task.1 = RA3
	BCF 0x024,1
	BTFSC PORTA,3
	BSF 0x024,1
; 49: Call getanalog()
	CALL L0002
; 50: Select Case task
; 51: Case 0  'sleep , do nothing
	MOVF 0x024,W
	SUBLW 0x00
	BTFSS STATUS,Z
	GOTO L0008
; 52: fb = 0
	BCF PORTA,5
; 53: time1 = 0
	CLRF 0x025
	CLRF 0x026
; 54: time2 = 0
	CLRF 0x02A
	CLRF 0x02B
; 55: Case 2  'programming mode
	GOTO L0009
L0008:
	MOVF 0x024,W
	SUBLW 0x02
	BTFSS STATUS,Z
	GOTO L0010
; 56: If current_2 > max_current_prog Then
	MOVF 0x02C,W
	MOVWF R0L
	MOVF 0x02D,W
	MOVWF R0H
	MOVLW 0x37
	MOVWF R1L
	CLRF R1H
	CALL C003
	BTFSS STATUS,Z
	GOTO L0011
; 57: fb = 1
	BSF PORTA,5
; 58: WaitMs puls_time
	MOVLW 0x7E
	MOVWF R4L
	MOVLW 0xBB
	MOVWF R4H
	CALL DL02
; 59: fb = 0
	BCF PORTA,5
; 60: Endif
L0011:
; 61: Case Else  'normal function, two outputs running.
	GOTO L0012
L0010:
; 62: If current_1 > max_current_1 Then
	MOVF 0x032,W
	MOVWF R0L
	MOVF 0x033,W
	MOVWF R0H
	MOVF 0x02E,W
	MOVWF R1L
	MOVF 0x02F,W
	MOVWF R1H
	CALL C003
	BTFSS STATUS,Z
	GOTO L0013
; 63: time1 = time1 + 1
	INCF 0x025,F
	BTFSC STATUS,Z
	INCF 0x026,F
; 64: If time1 > max_timing Then
	MOVF 0x025,W
	MOVWF R0L
	MOVF 0x026,W
	MOVWF R0H
	MOVLW 0xAC
	MOVWF R1L
	MOVLW 0x0D
	MOVWF R1H
	CALL C003
	BTFSS STATUS,Z
	GOTO L0014
; 65: time1 = max_timing
	MOVLW 0xAC
	MOVWF 0x025
	MOVLW 0x0D
	MOVWF 0x026
; 66: fb = 1
	BSF PORTA,5
; 67: Endif
L0014:
; 68: Endif
L0013:
; 69: If current_2 > max_current_2 Then
	MOVF 0x02C,W
	MOVWF R0L
	MOVF 0x02D,W
	MOVWF R0H
	MOVF 0x030,W
	MOVWF R1L
	MOVF 0x031,W
	MOVWF R1H
	CALL C003
	BTFSS STATUS,Z
	GOTO L0015
; 70: time2 = time2 + 1
	INCF 0x02A,F
	BTFSC STATUS,Z
	INCF 0x02B,F
; 71: If time2 > max_timing Then
	MOVF 0x02A,W
	MOVWF R0L
	MOVF 0x02B,W
	MOVWF R0H
	MOVLW 0xAC
	MOVWF R1L
	MOVLW 0x0D
	MOVWF R1H
	CALL C003
	BTFSS STATUS,Z
	GOTO L0016
; 72: time2 = max_timing
	MOVLW 0xAC
	MOVWF 0x02A
	MOVLW 0x0D
	MOVWF 0x02B
; 73: fb = 1
	BSF PORTA,5
; 74: Endif
L0016:
; 75: Endif
L0015:
; 76: EndSelect
L0012:
L0009:
; 77: Wend
	GOTO L0006
L0007:
; 78: 
; 79: End
L0017:	GOTO L0017
; 80: Proc getanalog()
L0002:
; 81: Adcin 0, current_1
	CLRF R0L
	CALL L0003
	MOVLB 0x01
	MOVF ADRESL,W
	MOVLB 0x00
	MOVWF 0x032
	MOVLB 0x01
	MOVF ADRESH,W
	MOVLB 0x00
	MOVWF 0x033
; 82: Adcin 1, current_2
	MOVLW 0x01
	MOVWF R0L
	CALL L0003
	MOVLB 0x01
	MOVF ADRESL,W
	MOVLB 0x00
	MOVWF 0x02C
	MOVLB 0x01
	MOVF ADRESH,W
	MOVLB 0x00
	MOVWF 0x02D
; 83: 
; 84: End Proc
	RETURN
; Library code
L0003:
	MOVLB 0x01
	BSF ADCON1,ADFM
	MOVLW 0x8f
	ANDWF ADCON1,f
	MOVLW 0x30
	IORWF ADCON1,f
	MOVLB 0x00
	RLF R0L,f
	RLF R0L,f
	MOVLW 0x7c
	ANDWF R0L,w
	MOVLB 0x01
	MOVWF ADCON0
	BSF ADCON0,ADON
	MOVLB 0x00
	MOVLW 0x13
	MOVWF R4L
	CALL DL01
	MOVLB 0x01
	BSF ADCON0,GO
	BTFSC ADCON0,GO
	BRA $-1
	BCF ADCON0,ADON
	MOVLB 0x00
	BCF PIR1,ADIF
	RETURN
; End of user code
L0018:	GOTO L0018
;
;
; Delay Routine Byte
; minimal routine execution time: 1.625s
; routine execution time step: 1s
; maximal routine execution time: 255.625s
DL01:
	NOP
	NOP
	NOP
	NOP
	NOP
	DECFSZ R4L,F
	GOTO DL01
	RETURN
; Delay Routine Word
; minimal routine execution time: 1.875s
; routine execution time step: 1.25s
; maximal routine execution time: 81920.63s
DL02:
	MOVLW 0x01
	SUBWF R4L,F
	CLRW
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF R4H,F
	BTFSS STATUS,C
	RETURN
	GOTO DL02
; Waitms Routine
W001:	MOVLW 0x01
	SUBWF R0L,F
	CLRW
	SUBWFB R0H,F
	BTFSS STATUS,C
	RETURN
	MOVLW 0x1E
	MOVWF R4L
	MOVLW 0x03
	MOVWF R4H
	CALL DL02
	GOTO W001
;
;
; Word Comparison Routine
C001:	MOVLW 0x05
	GOTO C007
C002:	MOVLW 0x02
	GOTO C007
C003:	MOVLW 0x06
	GOTO C007
C004:	MOVLW 0x03
	GOTO C007
C005:	MOVLW 0x04
	GOTO C007
C006:	MOVLW 0x01
C007:	MOVWF R4L
	MOVF R1H,W
	SUBWF R0H,W
	BTFSS STATUS,Z
	GOTO C008
	MOVF R1L,W
	SUBWF R0L,W
C008:	MOVLW 0x04
	BTFSC STATUS,C
	MOVLW 0x01
	BTFSC STATUS,Z
	MOVLW 0x02
	ANDWF R4L,W
	BTFSS STATUS,Z
	MOVLW 0xFF
	RETURN
;
;
; Configuration settings
	ORG 0x8007
	DW 0x0F84
	DW 0x1CFF
; End of listing
	END
