Define CONFIG = 0x23c2
Define CONFIG2 = 0x3eff

'program TT for PCBoard GCA145 / MGV145
'Universal version N_2.0  Speed for position 63, going to zero point, is set to minimum
'For sliding systems (FY) extra end switch is used.
'RB7 on ICSP1 (pin3) is endswitch (pass last rail)
'J4 is used as zero switch (pass first rail)
'EEP1 jumper is to be set permanatly On at MGV145, EEP1 on GCA145 can be omitted

'three extra position are possible:
'-  position 63 to go to zero switch and then to rail 1
'-  Position 62 to manually set all positions first time (Manual initialisation, only when eep1 is set)
'menu settings :
'0.0  correction actual position
'0.1  Max positions
'0.2  min speed
'0.3  max speed
'0.4  incr/decr delay
'0.5  extra correction steps
'0.6  bridge power normal/ reversed (Pos) at this position and all higher ones, bridge power is reversed
'0.7  Bridge power on/off (1/0) while moving
'0.8  setting of control type (0..4)
'-  control types:
'-    1 |control is set For turntable NO 'shortest way option' means that running from highest to lowest position (or v.v.) will NOT pass 0 position.|
'-    2 |control is set For turntable with  'shortest way option' which means that running from one to next position (or v.v.) could pass 0 position.|
'-    3 |version for two rail tt, no restriction on 'short way'. This is special for TT with contact rings  (no cables).|
'-    4 |fiddle yard.railpower. End switch at the High position side is needed.|
'0.9  pos_match delay
'1.0  motor start delay
'1.1  delay before relay is switched on
'1.2  selection manual or J5 or both control
'-      for control type see manual
'1.3  from V2.6
'-      Speed setting when running Pos62 or pos 63
'-      In these positions, rampup and ramp down is not possible.
'-      If you have a feeling it is too slow, just select the speed you want here.
'1.4  from V2.8 motor power always ON (=1)  default = 0
'1.5  Speed (max = 5,  minimum = 1)
'1.6  Write puls J5 pin 9) is used (1) or Not(0)
'1.7  swap direction of selector on GC146
'- V_N1_1 march 2014 maximum steps increased to 1,000,000
'-                   motor will be on hold with power on for 250 mSecs to be able to brake motor movement.
'- V_N1.2 nov 2014 menu 8 amd 9 are swapped
'-                 menu extended with 2 extra delay settings,
'-     menu 9   delay before motor starts after sending new value
'-     menu 10  delay after motor stops, before rails are switched on
'-     menu 11  delay between rails on and indication 'Systemn ready'is sent.
'- V_N1.3 nov 2014
'-     menue's changed to 0.1  0.2  etc.
'-     added menue 1.2 for selecting manual /computer control or both (commanding_input)
'-     easier menue selection
'- V_N1.5 nov 19, 2014 phg
'-    program switch on GCA146 no longer used.
'-    program mode is reached and released by pressing knob on GCA146 for more than 3 seconds.
'-    some minor improvements
'- V_N1.6
'-    Max-switch used in all control levels and also before motor starts
'-    Mene 1.3 is used to select inv(0) / not inv(1) of max-end switch input.
'-    default is set to 1.
'- V_N_1.7 nov 25 2014 phg
'- new calculation of accelaration and decelaration steps to achieve more linearity
'- V_N_20 March 15 2015 phg
'-    In menu 62 (setting positions) is extra forward turn for control type 1+2 to avoid wire twisting
'-    Several unnoticeable improvements.
'- V_N_2.2  24 mar 2015  Menu 1.2 + 1.3 cancelled due to memory limits
'- V_N_2.4  pulse time for stepmotor extended with 1 mSec
'- V_N_2.5  problem with relays solved
'- V_N_2.6  Setting for speed when using menu 62 or 63.
'- V_N_2.7  correction steps multiplied by two
'-          Extra menue 1.4 to enable automatic correction (63) if Pos 1 is chosen.
'- V_N_2.8  Startup issue solved
'-          Menu 1.4 for setting motor_power off  (1 =always on,, 0 = switch off)
'- V-N-3.0  1 july 2016 phg  At selection of Pos 63, the TT will go to last remembered position after zeroadjust
'-                           Menu 1.5 added to select speed  >> 1 = standard, 2 = half speed, 3 = 1/3 speed , etc
'- V-N-3.1 4 sept 2016 phg  After selecting pos 63, TT will run at speed (menu 1.3) to zero point and then use
'-           ramp up and down as nomal to get to last remembered position.
'-           menu 1.6 added to enable/disable write pin 9 of J5
'- V_N_3.2 - 4 jan 2017  maximum speed setting down to 1 (=highest speed)
'- V_N_3.3 - 14 june 2017 small misfunctions corrected.
'- V_N_3.4 - 26 dec 2017 menu 1.7 added to swap direction of SW1 on GC146
'-           Some types appear to function the opposite way.
'- V_N_3.5 - 9 Sept 2018 Acutal postion is also displayed via I2C connector (address  dec 68 & dec 116)
Dim temp_var As Single
Dim steps As Long
Dim half_steps As Long
Dim ramp_down_point As Long
Dim new_steps As Long
Dim act_steps As Long
Dim one_round As Long
Dim one_round_half As Long
Dim speed_min As Word
Dim speed_max As Word
Dim knob_pressed As Byte
Dim data_pointer As Byte

Dim menue_data_selector As Bit
Dim dot As Byte
Dim new_pos As Byte
Dim act_pos As Byte
Dim bus_pos As Byte
Dim old_bus_pos As Byte
Dim speed As Word
Dim new_encoder As Byte
Dim old_encoder As Byte
Dim manual_pos As Byte
Dim old_manual_pos As Byte
Dim result As Byte
Dim free_space_steps As Byte
Dim value As Byte
Dim old_value As Byte
Dim eprom_pointer As Byte
Dim encoder_count As Byte
Dim max_pos As Byte
Dim disp1_val As Byte
Dim disp10_val As Byte
Dim old_pos_write As Bit
Dim ramp_up As Bit
Dim speed_step As Byte
Dim version As Bit
Dim steps_set As Bit
Dim bridge_power As Byte
Dim pos_match_delay As Byte
Dim bridge_rev_pos As Byte
Dim ctrl_type As Byte
Dim turn_counter As Byte
Dim proceed As Bit
Dim motor_start_delay As Byte
Dim relay_on_delay As Byte
Dim longword As Word
Dim speed_changed As Bit
Dim speed_timer As Byte
Dim commanding_input As Byte
Dim pos_62_63_speed As Word
Dim motor_on_off As Byte
Dim speed_factor As Byte
Dim no_write_pulse As Byte
Dim sw1_swap As Byte
Dim bit_value As Bit

Const disp1 = 64
Const disp2 = 66
Const disp3 = 112
Const disp4 = 114
Const mem_act_pos = 201
Const mem_turn_counter = 202
Const mem_speed_min = 203
Const mem_speed_max = 204
Const mem_speed_step = 205
Const mem_one_round = 206  '4 BYTES RESERVED
Const mem_ctrl_type = 210
Const mem_max_pos = 211
Const mem_free_space = 212
Const mem_rev_pos = 214
Const mem_bridge_power = 215
Const mem_pos_match_delay = 216
Const mem_bridge_rev_pos = 217
Const mem_motor_start_delay = 218
Const mem_relay_on_delay = 219
Const mem_commanding_input = 220
Const mem_pos_62_63_speed = 221
Const mem_motor_on_off = 222
Const mem_speed_factor = 223
Const mem_no_write_pulse = 224
Const mem_sw1_swap = 225
Symbol swfw = RB0
Symbol swrev = RB1
Symbol sck = RB2
Symbol sda = RB3
Symbol ec1 = RC4
Symbol ec2 = RC5
Symbol pos_match = RB4
Symbol pos_write = RB5
Symbol direction = RC0
Symbol clk = RC1
Symbol motor_power = RC2
Symbol zero = RB6
Symbol max_end = RB7
'Symbol ec1 = RC4
'Symbol ec2 = RC5
Symbol ecsw = RC6
Dim pgm As Bit
Symbol adjust_en = RC3
AllDigital
INTCON.INTF = 0
OPTION_REG.PSA = 0  'prescaler assigned to timer0
OPTION_REG.PS0 = 1  'set the prescaler to 1:256
OPTION_REG.PS1 = 1
OPTION_REG.PS2 = 1
OPTION_REG.T0CS = 0  'use the instruction clock (Fosc/4) as the timer clock.
OPTION_REG.T0SE = 0  'bit 4 TMR0 Source Edge Select bit: 0=low/high / 1=high/low
INTCON.T0IF = 0  'clear the timer interrupt flag
TMR0 = 0  'load a value of 0 into the timer
'T1CON = 1
INTCON.T0IE = 1  'enable timer0 interrupt
INTCON.PIE1 = 0
INTCON.PEIE = 1
INTCON.GIE = 1
ADCON1 = %0110
AllDigital
TRISA = %111111
TRISB = %11101100
TRISC = %01111000
PORTB = %11101100
PORTC = %11111000
I2CPrepare sda, sck
dot = 0
WaitMs 2000
Gosub init_values
Call relays(1)
data_pointer = 0


main:
	Call binary_pos_out()
	knob_pressed = 0
	pgm = 0
	While ecsw = 0
		If knob_pressed < 120 Then
			knob_pressed = knob_pressed + 1
		Else
			Call i2c_display(100, 0)
		Endif
		WaitMs 25
	Wend
	Select Case knob_pressed
	Case 120
		pgm = 1
		Gosub adjust_settings
		knob_pressed = 0
		pgm = 0
	Case > 0
		If manual_pos <> old_manual_pos Then
			Call i2c_display(100, 0)
			old_manual_pos = manual_pos
			new_pos = manual_pos
			Gosub stepmotor
		Endif
		knob_pressed = 0
	Case Else
	EndSelect
	
	Select Case commanding_input
	Case 0  'manual control
		Gosub get_new_position_from_gca146
	Case 1  'computer control
		If no_write_pulse > 0 Then
			Gosub get_new_position_from_j5
		Else
			Gosub get_new_position_from_j5_no_wrtie_pulse
		Endif
	Case Else  'both
		Gosub get_new_position_from_gca146
		If no_write_pulse > 0 Then
			Gosub get_new_position_from_j5
		Else
			Gosub get_new_position_from_j5_no_wrtie_pulse
		Endif
	EndSelect
	WaitMs 10
	Goto main
End                                               
On Interrupt  'this routine increases speed_timer each 1/100 second
	speed_timer = speed_timer + 1
	TMR0 = 59
	INTCON.T0IF = 0  'clear timer interrupt flag
	INTCON.GIE = 1
Resume                                            

get_new_position_from_gca146:
	Gosub calc_rotation
	Select Case result
	Case 1
		Call check_encoder_count(1, 4)
		If proceed = 1 Then
			encoder_count = 0
			Select Case manual_pos
			Case < max_pos
				manual_pos = manual_pos + 1
			Case max_pos
				If adjust_en = 1 Then
					manual_pos = 63
				Else
					manual_pos = 62
				Endif
			Case 63
				manual_pos = 1
			Case 62
				manual_pos = 63
			Case Else
			EndSelect
			Call i2c_display(manual_pos, 0)
		Endif
	Case 2
		Call check_encoder_count(0, 4)
		If proceed = 1 Then
			encoder_count = 3
			Select Case manual_pos
			Case 62
				manual_pos = max_pos
			Case 63
				If adjust_en = 1 Then
					manual_pos = max_pos
				Else
					manual_pos = 62
				Endif
			Case 1
				manual_pos = 63
			Case 0
				manual_pos = 1
			Case Else
				manual_pos = manual_pos - 1
			EndSelect
			Call i2c_display(manual_pos, 0)
		Endif
	Case Else
	EndSelect
Return                                            

get_new_position_from_j5_no_wrtie_pulse:
'this routine is different from standard, there is no write pulse
	value = PORTA And 63  'now get value from J5
	If old_value <> value Then
		WaitMs 2000  'wait till position is totally send
		value = PORTA And 63  'now get value from J5
		Select Case value
		Case 63  'position reset is desired
			value = 63
		Case 0  'POS 0 NOT ALLOWED, KEEP OLD VALUE ALIVE
			value = old_value
		Case Else
			If value > max_pos Then  'this is not allowed
				value = old_value  'put it back to old situation
			Endif
		EndSelect
		Call i2c_display(value, 0)
		If value = old_value Then  'no other position is set, just a response on pos_write is required
			pos_match = 1
			WaitMs 1000
			pos_match = 0
		Endif
		old_pos_write = 1
		bus_pos = value  'now take over the desired position
		old_value = value
		If bus_pos <> old_bus_pos Then
			new_pos = bus_pos
			Gosub stepmotor
		Endif
	Endif
	WaitMs 2
Return                                            
get_new_position_from_j5:
	value = bus_pos  'remember the position
	If pos_write = 1 Then
		If old_pos_write = 0 Then  'react once on rising edge
			value = PORTA And 63  'now get value from J5
			Select Case value
			Case 63  'position reset is desired
				value = 63
			Case 0  'POS 0 NOT ALLOWED, KEEP OLD VALUE ALIVE
				value = bus_pos
			Case Else
				If value > max_pos Then  'this is not allowed
					value = bus_pos  'put it back to old situation
				Endif
			EndSelect
			Call i2c_display(value, 0)
			If value = bus_pos Then  'no other position is set, just a response on pos_write is required
				pos_match = 1
				WaitMs 1000
				pos_match = 0
			Endif
			old_pos_write = 1
		Endif
	Else
		old_pos_write = 0
	Endif
	bus_pos = value  'now take over the desired position
	If bus_pos <> old_bus_pos Then
		new_pos = bus_pos
		Gosub stepmotor
	Endif
	WaitMs 2
Return                                            


calc_rotation:  'this routine checks the incrimental switch
'1 = increasing value
'2 = decreasing value
'3 = no change
		new_encoder = 0
		Select Case sw1_swap
		Case 0
			new_encoder.0 = ec1
			new_encoder.1 = ec2
		Case Else
			new_encoder.1 = ec1
			new_encoder.0 = ec2
		EndSelect
		result = 0
		Select Case old_encoder
		Case 0
			result = LookUp(3, 2, 1, 3), new_encoder
		Case 1
			result = LookUp(1, 3, 3, 2), new_encoder
		Case 2
			result = LookUp(2, 3, 3, 1), new_encoder
		Case Else
			result = LookUp(3, 1, 2, 3), new_encoder
		EndSelect
		old_encoder = new_encoder
Return                                            

Proc check_encoder_count(decoder_direction As Bit, counts As Byte)
	proceed = 0
	If decoder_direction = 1 Then
		If encoder_count < counts Then
			encoder_count = encoder_count + 1
		Else
			encoder_count = 0
			proceed = 1
		Endif
	Else
		If encoder_count > 0 Then
			encoder_count = encoder_count - 1
		Else
			encoder_count = counts
			proceed = 1
		Endif
	Endif
End Proc                                          



adjust_settings:
	knob_pressed = 0
	Call relays(0)
	Gosub steps_reading
	speed_changed = 0
	menue_data_selector = 0
	new_steps = act_steps  'nothing is changed yet
'first bring valus back to readable values
	Call change_speed(0)
	While pgm = 1  'still in programming mode
		knob_pressed = 0
		While ecsw = 0
			If knob_pressed < 120 Then
				knob_pressed = knob_pressed + 1
			Else
				pgm = 0  'adjust mode endid
				Call i2c_display(100, 0)
			Endif
			WaitMs 25
		Wend
		Select Case knob_pressed
		Case 120
			pgm = 0  'leave adjust mode
		Case 0
		Case < 120
			menue_data_selector = Not menue_data_selector
		Case Else
		EndSelect
		If menue_data_selector = 0 Then
			dot = 1  'SHOW DOT FOR MENUE_DISPLAY
			motor_power = 0
			Gosub calc_rotation  'look for the knob to be turned
			Select Case result
			Case 1
				Call check_encoder_count(1, 4)
				If proceed = 1 Then
					If data_pointer < 17 Then
						data_pointer = data_pointer + 1
					Else
						data_pointer = 0
					Endif
				Endif
			Case 2
				Call check_encoder_count(0, 4)
				If proceed = 1 Then
					If data_pointer > 0 Then
						data_pointer = data_pointer - 1
					Else
						data_pointer = 17
					Endif
				Endif
			Case Else
			EndSelect
			Call i2c_display(data_pointer, dot)
		Else  'MENUE_DATA_SELECT0R = 1
			dot = 2
			If data_pointer > 0 Then
				motor_power = 0
			Endif
			Select Case data_pointer
			Case 0  'correction of current position
				Call i2c_display(act_pos, dot)
				Gosub calc_rotation  'look for the knob to be turned
				If speed_timer > 245 Then
					motor_power = 0
				Endif
				Select Case result
				Case 1
					Call check_encoder_count(1, 2)
					If proceed = 1 Then
						If new_steps < 1000000 Then
							motor_power = 1  'motor on
							new_steps = new_steps + 1
							direction = 1
							clk = 1  'clock out
							WaitUs speed_min
							clk = 0
							WaitMs 1
							speed_timer = 0
						Endif
					Endif
				Case 2
					Call check_encoder_count(0, 2)
					If proceed = 1 Then
						If new_steps > 0 Then
							motor_power = 1  'motor on
							new_steps = new_steps - 1
							direction = 0
							clk = 1  'clock out
							WaitUs speed_min
							clk = 0
							WaitMs 1
							speed_timer = 0
						Endif
					Endif
				Case Else
				EndSelect
			Case 1  'setting of maximum positions
				steps_set = 0
				Call i2c_display(max_pos, dot)
				Gosub calc_rotation
				Select Case result
				Case 1
					Call check_encoder_count(1, 4)
					If proceed = 1 Then
						If max_pos < 48 Then  'no more positions possible
							max_pos = max_pos + 1
							Write mem_max_pos, max_pos
						Endif
					Endif
				Case 2
					Call check_encoder_count(0, 4)
					If proceed = 1 Then
						If max_pos > 2 Then  'minimum 2 positions
							max_pos = max_pos - 1
							Write mem_max_pos, max_pos
						Endif
					Endif
				Case Else
				EndSelect
			Case 2  'setting of speed interval Minimum
					'setting will be done in multiple of 256 uSecs
					'minimum is usually not less then 5, and maximum is 100 (is real slow)
				steps_set = 0
				Call i2c_display(speed_min.HB, dot)
				Gosub calc_rotation
				Select Case result
				Case 1
					Call check_encoder_count(1, 4)
					If proceed = 1 Then
						If speed_min.HB < 100 Then  'display is limited to 100
							speed_min.HB = speed_min.HB + 1
							speed_changed = 1  'set flag for new speed-change calculation
						Endif
					Endif
				Case 2
					Call check_encoder_count(0, 4)
					If proceed = 1 Then
						If speed_min.HB > speed_max.HB Then
							speed_min.HB = speed_min.HB - 1
							speed_changed = 1  'set flag for new speed-change calculation
						Endif
					Endif
				Case Else
				EndSelect
			Case 3  'setting of speed interval Maximum
					'setting will be done in multiple of 256 uSecs
					'minimum is 1 and maximum is 100 (is real slow)
				steps_set = 0
				Call i2c_display(speed_max.HB, dot)
				Gosub calc_rotation
				Select Case result
				Case 1
					Call check_encoder_count(1, 4)
					If proceed = 1 Then
						If speed_max.HB < speed_min.HB Then  'not more then speed_min
							speed_max.HB = speed_max.HB + 1
							speed_changed = 1  'set flag for new speed-change calculation
						Endif
					Endif
				Case 2
					Call check_encoder_count(0, 4)
					If proceed = 1 Then
						If speed_max.HB > 1 Then
							speed_max.HB = speed_max.HB - 1
							speed_changed = 1  'set flag for new speed-change calculation
						Endif
					Endif
				Case Else
				EndSelect
			Case 4  'setting of ramp up and down speed
					'speed will be the value that speed will be changed every step up and down
				steps_set = 0
				Call i2c_display(speed_step, dot)
				Gosub calc_rotation
				Select Case result
				Case 1
					Call check_encoder_count(1, 4)
					If proceed = 1 Then
						If speed_step < 99 Then  'maximum 99 is possible
							speed_step = speed_step + 1
						Endif
					Endif
				Case 2
					Call check_encoder_count(0, 4)
					If proceed = 1 Then
						If speed_step > 0 Then
							speed_step = speed_step - 1
						Endif
					Endif
				Case Else
				EndSelect
			Case 5  'setting of extra free space steps
				steps_set = 0
				Call i2c_display(free_space_steps, dot)
				Gosub calc_rotation
				Select Case result
				Case 1
					Call check_encoder_count(1, 4)
					If proceed = 1 Then
						If free_space_steps < 99 Then  'display is limited to 100
							free_space_steps = free_space_steps + 1
							Write mem_free_space, free_space_steps
						Endif
					Endif
				Case 2
					Call check_encoder_count(0, 4)
					If proceed = 1 Then
						If free_space_steps > 0 Then
							free_space_steps = free_space_steps - 1
							Write mem_free_space, free_space_steps
						Endif
					Endif
				Case Else
				EndSelect
			Case 6  'at which postion is in bridge reversed power
				steps_set = 0
				Call i2c_display(bridge_rev_pos, dot)
				Gosub calc_rotation
				Select Case result
				Case 1
					Call check_encoder_count(1, 4)
					If proceed = 1 Then
						If bridge_rev_pos < max_pos Then  'no more positions possible
							bridge_rev_pos = bridge_rev_pos + 1
							Write mem_bridge_rev_pos, bridge_rev_pos
						Endif
					Endif
				Case 2
					Call check_encoder_count(0, 4)
					If proceed = 1 Then
						If bridge_rev_pos > 0 Then  '0 does not effect reversing
							bridge_rev_pos = bridge_rev_pos - 1
							Write mem_bridge_rev_pos, bridge_rev_pos
						Endif
					Endif
				Case Else
				EndSelect
			Case 7  'setting if power should be on or off while bridge is moving (0 = off)
				If bridge_power > 1 Then
					bridge_power = 1
				Endif
				Call i2c_display(bridge_power, dot)
				Gosub calc_rotation
				Select Case result
				Case 1
					Call check_encoder_count(1, 4)
					If proceed = 1 Then
						bridge_power = 1
						Write mem_bridge_power, bridge_power
					Endif
					
				Case 2
					Call check_encoder_count(0, 4)
					If proceed = 1 Then
						bridge_power = 0
						Write mem_bridge_power, bridge_power
					Endif
				Case Else
				EndSelect
			Case 8  'menu 8 , setting control type
				steps_set = 0
				Call i2c_display(ctrl_type, dot)
				Gosub calc_rotation
				Select Case result
				Case 1
					Call check_encoder_count(1, 4)
					If proceed = 1 Then
						If ctrl_type < 4 Then
							ctrl_type = ctrl_type + 1
							Write mem_ctrl_type, ctrl_type
						Endif
					Endif
				Case 2
					Call check_encoder_count(0, 4)
					If proceed = 1 Then
						If ctrl_type > 1 Then
							ctrl_type = ctrl_type - 1
							Write mem_ctrl_type, ctrl_type
						Endif
					Endif
				Case Else
				EndSelect
			Case 9  'setting delay in .1 secs before 'tt ready' is sent)
				Call i2c_display(pos_match_delay, dot)
				Gosub calc_rotation
				Select Case result
				Case 1
					Call check_encoder_count(1, 4)
					If proceed = 1 Then
						If pos_match_delay < 99 Then
							pos_match_delay = pos_match_delay + 1
							Write mem_pos_match_delay, pos_match_delay
						Endif
					Endif
				Case 2
					Call check_encoder_count(0, 4)
					If proceed = 1 Then
						If pos_match_delay > 0 Then
							pos_match_delay = pos_match_delay - 1
							Write mem_pos_match_delay, pos_match_delay
						Endif
					Endif
				Case Else
				EndSelect
			Case 10  'settting delay in .1 secs before motor starts after sening new position
				Call i2c_display(motor_start_delay, dot)
				Gosub calc_rotation
				Select Case result
				Case 1
					Call check_encoder_count(1, 4)
					If proceed = 1 Then
						If motor_start_delay < 99 Then
							motor_start_delay = motor_start_delay + 1
							Write mem_motor_start_delay, motor_start_delay
						Endif
					Endif
				Case 2
					Call check_encoder_count(0, 4)
					If proceed = 1 Then
						If motor_start_delay > 0 Then
							motor_start_delay = motor_start_delay - 1
							Write mem_motor_start_delay, motor_start_delay
						Endif
					Endif
				Case Else
				EndSelect
			Case 11  'settting delay in .1 secs before rails are switched on
				Call i2c_display(relay_on_delay, dot)
				Gosub calc_rotation
				Select Case result
				Case 1
					Call check_encoder_count(1, 4)
					If proceed = 1 Then
						If relay_on_delay < 99 Then
							relay_on_delay = relay_on_delay + 1
							Write mem_relay_on_delay, relay_on_delay
						Endif
					Endif
				Case 2
					Call check_encoder_count(0, 4)
					If proceed = 1 Then
						If relay_on_delay > 0 Then
							relay_on_delay = relay_on_delay - 1
							Write mem_relay_on_delay, relay_on_delay
						Endif
					Endif
				Case Else
				EndSelect
			Case 12  'settting FOR COMMANDING_INPUT
				Call i2c_display(commanding_input, dot)
				Gosub calc_rotation
				Select Case result
				Case 1
					Call check_encoder_count(1, 4)
					If proceed = 1 Then
						If commanding_input < 2 Then
							commanding_input = commanding_input + 1
							Write mem_commanding_input, commanding_input
						Endif
					Endif
				Case 2
					Call check_encoder_count(0, 4)
					If proceed = 1 Then
						If commanding_input > 0 Then
							commanding_input = commanding_input - 1
							Write mem_commanding_input, commanding_input
						Endif
					Endif
				Case Else
				EndSelect
			Case 13  'settting FOR POS62/63 APEED
				Call i2c_display(pos_62_63_speed.HB, dot)
				Gosub calc_rotation
				Select Case result
				Case 1
					Call check_encoder_count(1, 4)
					If proceed = 1 Then
						If pos_62_63_speed.HB < speed_min.HB Then
							pos_62_63_speed.HB = pos_62_63_speed.HB + 1
						Endif
					Endif
				Case 2
					Call check_encoder_count(0, 4)
					If proceed = 1 Then
						If pos_62_63_speed.HB > speed_max.HB Then
							pos_62_63_speed.HB = pos_62_63_speed.HB - 1
						Endif
					Endif
				Case Else
				EndSelect

			Case 14  'motor_on_off setting after position
				Call i2c_display(motor_on_off, dot)
				Gosub calc_rotation
				Select Case result
				Case 1
					Call check_encoder_count(1, 4)
					If proceed = 1 Then
						motor_on_off = 1
					Endif
				Case 2
					Call check_encoder_count(0, 4)
					If proceed = 1 Then
						motor_on_off = 0
					Endif
				Case Else
				EndSelect
			Case 15  'SPEED FACTOR SETTING (factor for all speeds)
				Call i2c_display(speed_factor, dot)
				Gosub calc_rotation
				Select Case result
				Case 1
					Call check_encoder_count(1, 4)
					If proceed = 1 Then
						If speed_factor < 5 Then
							speed_factor = speed_factor + 1
						Endif
					Endif
				Case 2
					Call check_encoder_count(0, 4)
					If proceed = 1 Then
						If speed_factor > 1 Then
							speed_factor = speed_factor - 1
						Endif
					Endif
				Case Else
				EndSelect
			Case 16  'no_write_pulse
				Call i2c_display(no_write_pulse, dot)
				Gosub calc_rotation
				Select Case result
				Case 1
					Call check_encoder_count(1, 4)
					If proceed = 1 Then
						no_write_pulse = 1
					Endif
				Case 2
					Call check_encoder_count(0, 4)
					If proceed = 1 Then
						no_write_pulse = 0
					Endif
				Case Else
				EndSelect
			Case 17  'reverse SW1 function
				Call i2c_display(sw1_swap, dot)
				Gosub calc_rotation
				bit_value = sw1_swap.0
				Select Case result
				Case 1
					Call check_encoder_count(1, 4)
					If proceed = 1 Then
						bit_value = Not bit_value
					Endif
				Case 2
					Call check_encoder_count(0, 4)
					If proceed = 1 Then
						bit_value = Not bit_value
					Endif
				Case Else
				
				EndSelect
				sw1_swap.0 = bit_value

			Case Else
				data_pointer = 0
			EndSelect
			WaitMs 2
		Endif
	Wend
		'***************   now check if changes have to BE written in eeprom
	motor_power = 0  'shut off motor
	If new_steps <> act_steps Then  'now save new position
		Gosub save_steps
	Endif
	Gosub save_all
	Call change_speed(1)
	Call i2c_display(act_pos, 0)
	Call binary_pos_out()
	Call relays(1)
Return                                            


Proc i2c_display(value As Byte, dot As Byte)
	Select Case value
	Case 100
		disp1_val = %10111111
		disp10_val = %10111111
	Case 117  'run back display shows rr (run reverse)
		disp1_val = %10101111
		disp10_val = %10101111
	Case 119  'SE om display (setting positions)
		disp10_val = %10010010
		disp1_val = %10000110
	Case Else
		disp1_val = value
		disp1_val = disp1_val Mod 10
		disp1_val = LookUp(%11000000, %11111001, %10100100, %10110000, %10011001, %10010010, %10000010, %11111000, %10000000, %10010000), disp1_val
		disp10_val = value
		disp10_val = disp10_val / 10
		If dot = 1 Then
			disp10_val = LookUp(%01000000, %11111001, %10100100, %10110000, %10011001, %10010010, %10000010, %11111000, %10000000, %10010000, %10111111), disp10_val
		Else
			disp10_val = LookUp(%11111111, %11111001, %10100100, %10110000, %10011001, %10010010, %10000010, %11111000, %10000000, %10010000, %10111111), disp10_val
		Endif
	EndSelect
	Select Case dot
	Case 1  'dot on left display on
		disp10_val.7 = 0
	Case 2  'dot on righthand display on
		disp1_val.7 = 0
	Case Else
	EndSelect
	I2CStart
	I2CSend disp1
	I2CSend disp1_val
	I2CStop
	I2CStart
	I2CSend disp3
	I2CSend disp1_val
	I2CStop
	I2CStart
	I2CSend disp2
	I2CSend disp10_val
	I2CStop
	I2CStart
	I2CSend disp4
	I2CSend disp10_val
	I2CStop
End Proc                                          


stepmotor:
	speed = 0
	Gosub steps_reading
	pos_match = 1  'indicate not in position
	Select Case new_pos
	Case 62  'this is the manual setting for each position
'this position is equal for all control types, except for max switch
'in case of control type < 6 the zero switch is used for total steps calculation
'and bridge will run one full round extra.
		Call relays(0, act_pos)
			motor_power = 1  'motor on
		If ctrl_type < 3 Then  'first make full turn forward to avoid cable twist problem
			direction = 1
			Call i2c_display(62, 0)
			Call run_to_zero_switch(0, 0, pos_62_63_speed)
			Call run_to_zero_switch(1, 0, pos_62_63_speed)
			Call run_to_zero_switch(0, 0, pos_62_63_speed)
		Endif
		direction = 0  'go backwards
		WaitMs 1000
		Call i2c_display(0, 0)
		Call run_to_zero_switch(1, 0, pos_62_63_speed)  'run until zero switch is activated
		WaitMs 1000  'Wait 1 sec
		one_round = 0  'start counting steps for one full circle
		act_pos = 1
		If ctrl_type < 4 Then  'now extra round to be made to calculate total steps
			Call i2c_display(117, 0)  'indicate rr.
			WaitMs 1000  'Wait 1 sec
			Call run_to_zero_switch(0, 1, pos_62_63_speed)  'RUN unti ZERO SWITCH is deactivated AND COUNT STEPS
			Call run_to_zero_switch(1, 1, pos_62_63_speed)  'RUN TO ZERO SWITCH AND COUNT STEPS
		Endif
		Gosub store_one_round
		Call i2c_display(0, 0)  'indicate position 0.
		WaitMs 1000  'Wait 1 sec
		direction = 1  'run forward
		value = 0  'now WE ARE IN ZERO POSITION NOW
		one_round = 0  'temporary use variable to count individual postitions
		Call i2c_display(119, 0)  'indicate SE (setting)
		While act_pos <= max_pos  'turn motor until max pos is reached
			clk = 1  'clock out
			WaitUs pos_62_63_speed
			clk = 0
			WaitMs 1
			one_round = one_round + 1
			If ecsw = 0 Then  'knob is pressed, save position and increase act_pos
				new_steps = one_round
				Gosub save_steps
				Call i2c_display(act_pos, 0)
				act_pos = act_pos + 1
				WaitMs 1000  'Wait 1 sec
				While ecsw = 0  'Check If knob is Not pressed
				Wend
			Endif
		Wend
		Write mem_turn_counter, 127  'reset turn_counter
		Gosub get_one_round  'now get the original value back
		direction = 0  'goto to zero switch
		motor_power = 1  'set anable on
		Call i2c_display(117, 0)
		WaitMs 1000  'Wait 1 sec
		Call run_to_zero_switch(1, 0, pos_62_63_speed)
		WaitMs 1000  'Wait 1 sec
		act_pos = 0
		new_pos = 1
		Gosub steps_reading
		direction = 1  'now forwards
		steps = new_steps + free_space_steps
		steps = steps + free_space_steps  'add free-space twice
		ramp_up = 1
		ramp_down_point = 0
		motor_power = 1  'set Enable on
		Call i2c_display(0, 0)
		WaitMs 1000  'Wait 1 sec
		Call run_to_zero(pos_62_63_speed, 0)
		Call i2c_display(1, 0)
		WaitMs 1000  'Wait 1 sec
		steps = free_space_steps * 2
		direction = 0  'now go back the free-space correction
		Call i2c_display(117, 0)
		WaitMs 1000  'Wait 1 sec
		Call run_to_zero(pos_62_63_speed, 0)
		motor_power = motor_on_off.0  'motor off (or not)
	Case 63  'go to zero switch and then to last remembered position
		Call relays(0, act_pos)
		direction = 0  'goto to zero switch
		WaitMs 1000
		Call i2c_display(63, 0)
		motor_power = 1  'MOTOR on
		Call run_to_zero_switch(1, 0, pos_62_63_speed)  'first run backwards until zero switch comes in
		Call i2c_display(0, 0)
'Call run_to_zero_switch(0, 0, pos_62_63_speed)  'run more until zero switch is off again
'direction = 1
'Call run_to_zero_switch(1, 0, pos_62_63_speed)  'now run forwards until zero switch comes in
		WaitMs 1000  'Wait 1 sec
		new_pos = act_pos
		Gosub steps_reading
		direction = 1  'now forwards
		steps = new_steps
		Call i2c_display(new_pos, 0)
		speed = speed_min
		speed_timer = 0
		ramp_up = 1
		ramp_down_point = steps
		half_steps = steps / 2

		While steps > 0  'NOW RUN UNTIL STEPS = 0
			clk = 1  'clock out
			WaitUs speed
			clk = 0
			Gosub speed_calc
			steps = steps - 1
			If max_end = 0 Then  'CHECK SECURITY SWITCH
				Gosub stop_the_motor
			Endif
		Wend
		'Call run_to_zero(max_speed, 1)
		motor_power = motor_on_off.0  'motor off (or not)
		WaitMs 1000  'Wait 1 sec

	Case Else  'this is the normal position sequence
		steps = 0
		one_round_half = one_round / 2
		If new_steps > act_steps Then
			steps = new_steps - act_steps
			direction = 1
		Else
			steps = act_steps - new_steps
			direction = 0
		Endif
		Gosub check_0_pass_allowed
		If steps > 0 Then  'motor must be activated
			If direction = 0 Then
				steps = steps + free_space_steps
				steps = steps + free_space_steps
			Endif
			ramp_up = 1
			ramp_down_point = steps
			half_steps = steps / 2
			speed = speed_min
			For value = 1 To motor_start_delay
				WaitMs 100
			Next value
			Call relays(0, act_pos)
			motor_power = 1  'set anable on
			Call i2c_display(new_pos, 0)
			speed_timer = 0
			While steps > 0  'NOW RUN UNTIL STEPS = 0
				clk = 1  'clock out
				WaitUs speed
				clk = 0
				Gosub speed_calc
				steps = steps - 1
				If max_end = 0 Then  'CHECK SECURITY SWITCH
					Gosub stop_the_motor
				Endif
			Wend
			If direction = 0 Then
				If free_space_steps > 0 Then
					ramp_up = 1
					Call i2c_display(117, 0)
					WaitMs 1000  'Wait 1 sec
					steps = free_space_steps * 2
					ramp_down_point = steps
					direction = 1  'now go back the free-space correction
					While steps > 0  'NOW RUN UNTIL STEPS = 0
						clk = 1  'clock out
						WaitUs speed
						clk = 0
						Gosub speed_calc
						steps = steps - 1
						If max_end = 0 Then  'CHECK SECURITY SWITCH
							Gosub stop_the_motor
						Endif
					Wend
				Endif
			Endif
		Endif
		motor_power = motor_on_off.0  'motor off (or not)
	EndSelect
	For value = 1 To relay_on_delay
		WaitMs 100
	Next value
	act_pos = new_pos
	Call relays(1, act_pos)
	For value = 1 To pos_match_delay
		WaitMs 100
	Next value
	pos_match = 0
	Call i2c_display(act_pos, 0)
	Write mem_act_pos, act_pos
	bus_pos = act_pos
	old_bus_pos = act_pos
	manual_pos = act_pos
	old_manual_pos = act_pos
	Call binary_pos_out()
Return                                            
Proc binary_pos_out()
	I2CStart
	I2CSend 68
	I2CSend act_pos
	I2CStop
	I2CStart
	I2CSend 116
	I2CSend act_pos
	I2CStop
End Proc                                          
Proc run_to_zero_switch(bitposition As Bit, counting As Bit, speed As Word)
	If counting = 1 Then
		While zero = bitposition  'NOW RUN UNTIL switch is activated
			clk = 1  'clock out
			WaitUs speed
			clk = 0
			one_round = one_round + 1
		Wend
	Else
		While zero = bitposition  'NOW RUN UNTIL switch is activated
			clk = 1  'clock out
			WaitUs speed
			clk = 0
		Wend
	Endif
End Proc                                          

check_0_pass_allowed:
	If steps > one_round_half Then
		Select Case ctrl_type
		Case 2  'crossing zero possible but only if not too many turns in one direction
			Read mem_turn_counter, turn_counter  'get the total turns
			If turn_counter > 124 And direction = 1 Then  'crossing point zero in direction 0 allowed
				turn_counter = turn_counter - 1  'substract 1 pass
				Write mem_turn_counter, turn_counter
				direction = 0  'change direction
				steps = one_round - steps  'set the number of steps for the other direction
			Else
				If turn_counter < 130 And direction = 0 Then  'crossing point zero in direction 1 allowed
					turn_counter = turn_counter + 1
					Write mem_turn_counter, turn_counter  'add 1 pass
					direction = 1  'change direction
					steps = one_round - steps  'set the number of steps for the other direction
				Endif
			Endif
		Case 3  'shortest way always possible
			direction = Not direction  'change direction
			steps = one_round - steps  'set the number of steps for the other direction
		Case Else  'no zero crossing allowed
		EndSelect
	Endif
Return                                            


speed_calc:
	If speed_timer >= speed_step Then
		speed_timer = 0
		If steps < half_steps Then  'at this point  ramp up MUST end half way
			If ramp_up = 1 Then
				ramp_down_point = ramp_down_point - steps  'this counts down with the steps
				ramp_up = 0
			Endif
		Endif
		If ramp_up = 1 Then  'we were supposed to ramp up
			If speed > speed_max Then
				temp_var = speed / 1.02
				speed = temp_var
			Else
				ramp_down_point = ramp_down_point - steps  'this counts down with the steps
				ramp_up = 0
			Endif
		Else
			If steps < ramp_down_point Then  'this is the point tot start ramp down
				If speed < speed_min Then
					temp_var = speed * 1.02
					speed = temp_var
				Endif
			Endif
		Endif
	Endif
Return                                            

save_all:
	Write mem_ctrl_type, ctrl_type
	Write mem_speed_min, speed_min.HB
	Write mem_speed_max, speed_max.HB
	Gosub store_one_round
	Write mem_max_pos, max_pos
	Write mem_bridge_rev_pos, bridge_rev_pos
	Write mem_free_space, free_space_steps
	Write mem_speed_step, speed_step
	Write mem_pos_match_delay, pos_match_delay
	Write mem_relay_on_delay, relay_on_delay
	Write mem_motor_start_delay, motor_start_delay
	Write mem_bridge_power, bridge_power
	Write mem_pos_62_63_speed, pos_62_63_speed.HB
	Write mem_motor_on_off, motor_on_off
	Write mem_speed_factor, speed_factor
	Write mem_no_write_pulse, no_write_pulse
	Write mem_sw1_swap, sw1_swap
Return                                            


init_values:
	Call i2c_display(35, 1)  'indicate version number
	WaitMs 3000
	encoder_count = 0
	speed_min = 0
	
	Read mem_ctrl_type, ctrl_type
	If ctrl_type > 4 Or ctrl_type = 0 Then
		ctrl_type = 1
		Write mem_ctrl_type, ctrl_type
	Endif
	
	Read mem_speed_min, speed_min.HB
	If speed_min.HB > 99 Then
		speed_min.HB = 30
		Write mem_speed_min, speed_min.HB
	Else
		If speed_min.HB < 8 Then
			speed_min.HB = 8
			Write mem_speed_min, speed_min.HB
		Endif
	Endif
	speed_max = 0
	Read mem_speed_max, speed_max.HB
	If speed_max.HB > speed_min.HB Then
		speed_max.HB = 8
		Write mem_speed_max, speed_max.HB
	Else
		If speed_max.HB < 1 Then
			speed_max.HB = 1
			Write mem_speed_max, speed_max.HB
		Endif
	Endif

	eprom_pointer = mem_one_round
	Gosub get_one_round
	If one_round > 1000000 Then
		one_round = 0
	Endif
	one_round_half = one_round / 2

	Read mem_max_pos, max_pos
	If max_pos > 48 Or max_pos < 2 Then
		max_pos = 12
		bridge_rev_pos = 7
		Write mem_max_pos, max_pos
		Write mem_bridge_rev_pos, bridge_rev_pos
	Endif
	
	Read mem_bridge_rev_pos, bridge_rev_pos
	If bridge_rev_pos > max_pos Then
		bridge_rev_pos = max_pos / 2
		Write mem_bridge_rev_pos, bridge_rev_pos
	Endif
	
	Read mem_act_pos, act_pos
	If act_pos > max_pos Then
		act_pos = 1
		Write mem_act_pos, act_pos
	Endif
	Call i2c_display(act_pos, 0)
	Read mem_free_space, free_space_steps
	If free_space_steps > 99 Then
		free_space_steps = 99
		Write mem_free_space, free_space_steps
	Endif
	Read mem_speed_step, speed_step
	If speed_step > 99 Then
		speed_step = 5
		Write mem_speed_step, speed_step
	Endif
	
	Read mem_pos_match_delay, pos_match_delay
	If pos_match_delay > 50 Then
		pos_match_delay = 10
		Write mem_pos_match_delay, pos_match_delay
	Endif

	Read mem_relay_on_delay, relay_on_delay
	If relay_on_delay > 99 Then
		relay_on_delay = 10
		Write mem_relay_on_delay, relay_on_delay
	Endif
	
	Read mem_motor_start_delay, motor_start_delay
	If motor_start_delay > 99 Then
		motor_start_delay = 10
		Write mem_motor_start_delay, motor_start_delay
	Endif
	
	pos_62_63_speed = 0  'reset this variabele
	Read mem_pos_62_63_speed, pos_62_63_speed.HB
	If pos_62_63_speed.HB > speed_max.HB Then
		pos_62_63_speed.HB = 10
		Write mem_pos_62_63_speed, 10
	Endif
	
	Read mem_commanding_input, commanding_input
	If commanding_input > 2 Then
		commanding_input = 2
	Endif
	
	Read mem_bridge_power, bridge_power
	Read mem_motor_on_off, motor_on_off
	If motor_on_off > 1 Then
		motor_on_off = 0
	Endif
	Read mem_speed_factor, speed_factor
	If speed_factor > 5 Then
		speed_factor = 1
	Endif
	Read mem_no_write_pulse, no_write_pulse
	If no_write_pulse > 1 Then
		no_write_pulse = 1
	Endif
	Read mem_sw1_swap, sw1_swap
	If sw1_swap > 1 Then
		sw1_swap = 1
	Endif
	
	Call change_speed(1)
	steps_set = 0
	new_pos = act_pos
	bus_pos = act_pos
	old_bus_pos = act_pos
	manual_pos = act_pos
	old_manual_pos = act_pos
	old_pos_write = 1
'now read control input form J5 and store it
	value = PORTA And 63  'now get value from J5
	old_value = value
	
Return                                            


steps_reading:
	Select Case act_pos
	Case 63, 62
		act_steps = 0
	Case Else
		eprom_pointer = act_pos
		Read eprom_pointer, longword.LB
		eprom_pointer = eprom_pointer + 48
		Read eprom_pointer, longword.HB
		act_steps.LW = longword
		eprom_pointer = eprom_pointer + 48
		Read eprom_pointer, longword.LB
		longword.HB = 0
		act_steps.HW = longword
	EndSelect
	Select Case new_pos
	Case 62, 63
		new_steps = 0
	Case Else
		eprom_pointer = new_pos
		Read eprom_pointer, longword.LB
		eprom_pointer = eprom_pointer + 48
		Read eprom_pointer, longword.HB
		new_steps.LW = longword
		eprom_pointer = eprom_pointer + 48
		Read eprom_pointer, longword.LB
		longword.HB = 0
		new_steps.HW = longword
	EndSelect
Return                                            


save_steps:
	eprom_pointer = act_pos
	longword = new_steps.LW
	Write eprom_pointer, longword.LB
	eprom_pointer = eprom_pointer + 48
	Write eprom_pointer, longword.HB
	longword = new_steps.HW
	eprom_pointer = eprom_pointer + 48
	Write eprom_pointer, longword.LB
Return                                            


stop_the_motor:
	motor_power = motor_on_off.0  'motor off (or not)
	value = act_pos
	version = 0  'decimal point in display on
	While ecsw = 1
		WaitMs 200
		Call i2c_display(new_pos, 0)
		WaitMs 200
		Call i2c_display(100, 0)
	Wend
	Call i2c_display(new_pos, 0)
	motor_power = 1  'set enable on
Return                                            

store_one_round:
	eprom_pointer = mem_one_round
	longword = one_round.LW
	Write eprom_pointer, longword.LB
	eprom_pointer = eprom_pointer + 1
	Write eprom_pointer, longword.HB
	longword = one_round.HW
	eprom_pointer = eprom_pointer + 1
	Write eprom_pointer, longword.LB
	one_round_half = one_round / 2
Return                                            

get_one_round:
	eprom_pointer = mem_one_round
	Read eprom_pointer, longword.LB
	eprom_pointer = eprom_pointer + 1
	Read eprom_pointer, longword.HB
	one_round.LW = longword
	eprom_pointer = eprom_pointer + 1
	Read eprom_pointer, longword.LB
	longword.HB = 0
	one_round.HW = longword
Return                                            

Proc change_speed(which_direction As Bit)
	If which_direction = 1 Then  'back to control values
		speed_min = 0
		Read mem_speed_min, speed_min.HB
		speed_min = speed_min * speed_factor
		speed_max = 0
		Read mem_speed_max, speed_max.HB
		speed_max = speed_max * speed_factor
		pos_62_63_speed = 0
		Read mem_pos_62_63_speed, pos_62_63_speed.HB
		pos_62_63_speed = pos_62_63_speed * speed_factor
	Else  'make values useable for settings
		speed_min = speed_min / speed_factor
		speed_max = speed_max / speed_factor
		pos_62_63_speed = pos_62_63_speed / speed_factor
	Endif
End Proc                                          

Proc run_to_zero(speed As Word, calc As Bit)
	While steps > 0  'NOW RUN UNTIL STEPS = 0
		clk = 1  'clock out
		WaitUs speed
		clk = 0
		WaitMs 1
		steps = steps - 1
	Wend
End Proc                                          

Proc relays(onoff As Bit, pos As Byte)
	Select Case bridge_rev_pos
	Case <= pos
		swfw = 0
		If onoff = 0 Then
			swrev = bridge_power.0
		Else
			swrev = 1
		Endif
	Case Else
		swrev = 0
		If onoff = 0 Then
			swfw = bridge_power.0
		Else
			swfw = 1
		Endif
	EndSelect
End Proc                                          
