; Compiled with: OshonSoft PIC Basic Compiler v8.34
; Microcontroller model: PIC16F628A
; Clock frequency: 4.0MHz
;
	R0L EQU 0x020
	R0H EQU 0x021
	R4L EQU 0x028
	R4H EQU 0x029
	R0HL EQU 0x020
	R4HL EQU 0x028
	W_TEMP EQU 0x07F
	STATUS_TEMP EQU 0x07E
;       The value of 'time' (global) is 40
;       The address of 'halltime1' (byte) (global) is 0x022
;       The address of 'halltime2' (byte) (global) is 0x023
;       The address of 'halltime3' (byte) (global) is 0x024
;       The address of 'halltime4' (byte) (global) is 0x025
;       The address of 'halltime5' (byte) (global) is 0x026
;       The address of 'halltime6' (byte) (global) is 0x027
;       The address of 'halltime7' (byte) (global) is 0x02A
;       The address of 'halltime8' (byte) (global) is 0x02B
;       The address of 'hall1' (bit) (global) is 0x005,1
;       The address of 'hall2' (bit) (global) is 0x005,2
;       The address of 'hall3' (bit) (global) is 0x005,0
;       The address of 'hall4' (bit) (global) is 0x005,3
;       The address of 'hall5' (bit) (global) is 0x005,7
;       The address of 'hall6' (bit) (global) is 0x005,4
;       The address of 'hall7' (bit) (global) is 0x005,6
;       The address of 'hall8' (bit) (global) is 0x005,5
;       The address of 'fb1' (bit) (global) is 0x006,4
;       The address of 'fb2' (bit) (global) is 0x006,5
;       The address of 'fb3' (bit) (global) is 0x006,6
;       The address of 'fb4' (bit) (global) is 0x006,7
;       The address of 'fb5' (bit) (global) is 0x006,3
;       The address of 'fb6' (bit) (global) is 0x006,2
;       The address of 'fb7' (bit) (global) is 0x006,1
;       The address of 'fb8' (bit) (global) is 0x006,0
	ORG 0x0000
	BCF PCLATH,4
	BCF PCLATH,3
	GOTO L0002
	ORG 0x0004
	MOVWF W_TEMP
	SWAPF STATUS,W
	CLRF STATUS
	MOVWF STATUS_TEMP
	CALL L0003
	SWAPF STATUS_TEMP,W
	MOVWF STATUS
	SWAPF W_TEMP,F
	SWAPF W_TEMP,W
	RETFIE
; User code start
L0002:
; 1: 'program GCA173_optogateV11
; 2: 'pulse extender for optogate with inverted outputs
; 3: 'all outputs are normal high
; 4: 'Output will be low if according input is high, caused by interuupoting the ir light beam.
; 5: 'output will be high after 200 mSec and input = low.
; 6: '4 july 2023 initial start of this version
; 7: Define CONF_WORD = 0x3f50
;       The value of 'CONF_WORD' is 16208
; 8: Define CLOCK_FREQUENCY = 4
;       The value of 'CLOCK_FREQUENCY' is 4
; 9: 'NOT COMPILED: Dim startbyte As Byte
; 10: CMCON = 7
	MOVLW 0x07
	MOVWF CMCON
; 11: TRISA = 255
	MOVLW 0xFF
	BSF STATUS,RP0
	MOVWF TRISA
; 12: TRISB = 0
	CLRF TRISB
	BCF STATUS,RP0
; 13: PORTB = 255
	MOVLW 0xFF
	MOVWF PORTB
; 14: 
; 15: 
; 16: Symbol hall1 = RA1
; 17: Symbol hall2 = RA2
; 18: Symbol hall3 = RA0
; 19: Symbol hall4 = RA3
; 20: Symbol hall5 = RA7
; 21: Symbol hall6 = RA4
; 22: Symbol hall7 = RA6
; 23: Symbol hall8 = RA5
; 24: Symbol fb1 = RB4
; 25: Symbol fb2 = RB5
; 26: Symbol fb3 = RB6
; 27: Symbol fb4 = RB7
; 28: Symbol fb5 = RB3
; 29: Symbol fb6 = RB2
; 30: Symbol fb7 = RB1
; 31: Symbol fb8 = RB0
; 32: Dim halltime1 As Byte
	CLRF 0x022
; 33: Dim halltime2 As Byte
	CLRF 0x023
; 34: Dim halltime3 As Byte
	CLRF 0x024
; 35: Dim halltime4 As Byte
	CLRF 0x025
; 36: Dim halltime5 As Byte
	CLRF 0x026
; 37: Dim halltime6 As Byte
	CLRF 0x027
; 38: Dim halltime7 As Byte
	CLRF 0x02A
; 39: Dim halltime8 As Byte
	CLRF 0x02B
; 40: Dim clock As Byte
	CLRF 0x02C
; 41: Const time = 40  'interrupt  every 250 uSec , timing 80 mSec after hall(x) becomes high
; 42: OPTION_REG.T0CS = 0  'Bit 5 TMR0 clock source Select Bit: 0 = internal clock(clko) / 1 = transition On t0cki pin
	BSF STATUS,RP0
	BCF OPTION_REG,5
; 43: OPTION_REG.T0SE = 0  '; ; Bit 4 TMR0 source edge Select Bit: 0 = Low / High / 1 = High / Low
	BCF OPTION_REG,4
; 44: OPTION_REG.PSA = 0  '; ; Bit 3 prescaler assignment Bit: 0 = prescaler is assigned To the wdt
	BCF OPTION_REG,3
; 45: OPTION_REG.PS2 = 0  '; ; bits 2 - 0 PS2: PS0: prescaler rate Select bits
	BCF OPTION_REG,2
; 46: OPTION_REG.PS1 = 0  ';
	BCF OPTION_REG,1
; 47: OPTION_REG.PS0 = 0  ';
	BCF OPTION_REG,0
	BCF STATUS,RP0
; 48: TMR0 = 6  '; ; preset For timer register
	MOVLW 0x06
	MOVWF TMR0
; 49: INTCON.T0IE = 1  'enable Timer0 interrupts
	BSF INTCON,5
; 50: INTCON.T0IF = 0  'enable new TMR0 interrupts
	BCF INTCON,2
; 51: INTCON.GIE = True  'enable all un-masked interrupts
	BSF INTCON,7
; 52: OPTION_REG.T0CS = False  'set Timer0 clock source to internal instruction cycle clock
	BSF STATUS,RP0
	BCF OPTION_REG,5
	BCF STATUS,RP0
; 53: WaitMs 2000
	MOVLW 0xD0
	MOVWF R0L
	MOVLW 0x07
	MOVWF R0H
	CALL W001
; 54: fb1 = 0
	BCF PORTB,4
; 55: WaitMs 100
	MOVLW 0x0E
	MOVWF R4L
	MOVLW 0x27
	MOVWF R4H
	CALL DL02
; 56: fb1 = 1
	BSF PORTB,4
; 57: fb2 = 0
	BCF PORTB,5
; 58: WaitMs 100
	MOVLW 0x0E
	MOVWF R4L
	MOVLW 0x27
	MOVWF R4H
	CALL DL02
; 59: fb2 = 1
	BSF PORTB,5
; 60: fb3 = 0
	BCF PORTB,6
; 61: WaitMs 100
	MOVLW 0x0E
	MOVWF R4L
	MOVLW 0x27
	MOVWF R4H
	CALL DL02
; 62: fb3 = 1
	BSF PORTB,6
; 63: fb4 = 0
	BCF PORTB,7
; 64: WaitMs 100
	MOVLW 0x0E
	MOVWF R4L
	MOVLW 0x27
	MOVWF R4H
	CALL DL02
; 65: fb4 = 1
	BSF PORTB,7
; 66: fb5 = 0
	BCF PORTB,3
; 67: WaitMs 100
	MOVLW 0x0E
	MOVWF R4L
	MOVLW 0x27
	MOVWF R4H
	CALL DL02
; 68: fb5 = 1
	BSF PORTB,3
; 69: fb6 = 0
	BCF PORTB,2
; 70: WaitMs 100
	MOVLW 0x0E
	MOVWF R4L
	MOVLW 0x27
	MOVWF R4H
	CALL DL02
; 71: fb6 = 1
	BSF PORTB,2
; 72: fb7 = 0
	BCF PORTB,1
; 73: WaitMs 100
	MOVLW 0x0E
	MOVWF R4L
	MOVLW 0x27
	MOVWF R4H
	CALL DL02
; 74: fb7 = 1
	BSF PORTB,1
; 75: fb8 = 0
	BCF PORTB,0
; 76: WaitMs 100
	MOVLW 0x0E
	MOVWF R4L
	MOVLW 0x27
	MOVWF R4H
	CALL DL02
; 77: fb8 = 1
	BSF PORTB,0
; 78: WaitMs 1000
	MOVLW 0xE8
	MOVWF R0L
	MOVLW 0x03
	MOVWF R0H
	CALL W001
; 79: main:
L0001:
; 80: 'hallsensor 1
; 81: If hall1 = 1 Then
	BTFSS 0x005,1
	GOTO L0004
; 82: halltime1 = 8
	MOVLW 0x08
	MOVWF 0x022
; 83: fb1 = 0
	BCF PORTB,4
; 84: Else
	GOTO L0005
L0004:
; 85: If halltime1 = 0 Then
	MOVF 0x022,W
	SUBLW 0x00
	BTFSS STATUS,Z
	GOTO L0006
; 86: fb1 = 1
	BSF PORTB,4
; 87: Endif
L0006:
; 88: Endif
L0005:
; 89: 
; 90: 'hallsensor 2
; 91: If hall2 = 1 Then
	BTFSS 0x005,2
	GOTO L0007
; 92: halltime2 = 8
	MOVLW 0x08
	MOVWF 0x023
; 93: fb2 = 0
	BCF PORTB,5
; 94: Else
	GOTO L0008
L0007:
; 95: If halltime2 = 0 Then
	MOVF 0x023,W
	SUBLW 0x00
	BTFSS STATUS,Z
	GOTO L0009
; 96: fb2 = 1
	BSF PORTB,5
; 97: Endif
L0009:
; 98: Endif
L0008:
; 99: 
; 100: 'hallsensor 3
; 101: If hall3 = 1 Then
	BTFSS 0x005,0
	GOTO L0010
; 102: halltime3 = 8
	MOVLW 0x08
	MOVWF 0x024
; 103: fb3 = 0
	BCF PORTB,6
; 104: Else
	GOTO L0011
L0010:
; 105: If halltime3 = 0 Then
	MOVF 0x024,W
	SUBLW 0x00
	BTFSS STATUS,Z
	GOTO L0012
; 106: fb3 = 1
	BSF PORTB,6
; 107: Endif
L0012:
; 108: Endif
L0011:
; 109: 'hallsensor 4
; 110: If hall4 = 1 Then
	BTFSS 0x005,3
	GOTO L0013
; 111: halltime4 = 8
	MOVLW 0x08
	MOVWF 0x025
; 112: fb4 = 0
	BCF PORTB,7
; 113: Else
	GOTO L0014
L0013:
; 114: If halltime4 = 0 Then
	MOVF 0x025,W
	SUBLW 0x00
	BTFSS STATUS,Z
	GOTO L0015
; 115: fb4 = 1
	BSF PORTB,7
; 116: Endif
L0015:
; 117: Endif
L0014:
; 118: 
; 119: 'hallsensor 5
; 120: If hall5 = 1 Then
	BTFSS 0x005,7
	GOTO L0016
; 121: halltime5 = 8
	MOVLW 0x08
	MOVWF 0x026
; 122: fb5 = 0
	BCF PORTB,3
; 123: Else
	GOTO L0017
L0016:
; 124: If halltime5 = 0 Then
	MOVF 0x026,W
	SUBLW 0x00
	BTFSS STATUS,Z
	GOTO L0018
; 125: fb5 = 1
	BSF PORTB,3
; 126: Endif
L0018:
; 127: Endif
L0017:
; 128: 
; 129: 'hallsensor 6
; 130: If hall6 = 1 Then
	BTFSS 0x005,4
	GOTO L0019
; 131: halltime6 = 8
	MOVLW 0x08
	MOVWF 0x027
; 132: fb6 = 0
	BCF PORTB,2
; 133: Else
	GOTO L0020
L0019:
; 134: If halltime6 = 0 Then
	MOVF 0x027,W
	SUBLW 0x00
	BTFSS STATUS,Z
	GOTO L0021
; 135: fb6 = 1
	BSF PORTB,2
; 136: Endif
L0021:
; 137: Endif
L0020:
; 138: 
; 139: 'hallsensor 7
; 140: If hall7 = 1 Then
	BTFSS 0x005,6
	GOTO L0022
; 141: halltime7 = 8
	MOVLW 0x08
	MOVWF 0x02A
; 142: fb7 = 0
	BCF PORTB,1
; 143: Else
	GOTO L0023
L0022:
; 144: If halltime7 = 0 Then
	MOVF 0x02A,W
	SUBLW 0x00
	BTFSS STATUS,Z
	GOTO L0024
; 145: fb7 = 1
	BSF PORTB,1
; 146: Endif
L0024:
; 147: Endif
L0023:
; 148: 
; 149: 'hallsensor 8
; 150: If hall8 = 1 Then
	BTFSS 0x005,5
	GOTO L0025
; 151: halltime8 = 8
	MOVLW 0x08
	MOVWF 0x02B
; 152: fb8 = 0
	BCF PORTB,0
; 153: Else
	GOTO L0026
L0025:
; 154: If halltime8 = 0 Then
	MOVF 0x02B,W
	SUBLW 0x00
	BTFSS STATUS,Z
	GOTO L0027
; 155: fb8 = 1
	BSF PORTB,0
; 156: Endif
L0027:
; 157: Endif
L0026:
; 158: If clock = time Then
	MOVF 0x02C,W
	SUBLW 0x28
	BTFSS STATUS,Z
	GOTO L0028
; 159: clock = 0
	CLRF 0x02C
; 160: If halltime1 > 0 Then
	MOVF 0x022,W
	SUBLW 0x00
	BTFSC STATUS,C
	GOTO L0029
; 161: halltime1 = halltime1 - 1
	DECF 0x022,F
; 162: Else
	GOTO L0030
L0029:
; 163: fb1 = 1
	BSF PORTB,4
; 164: Endif
L0030:
; 165: If halltime2 > 0 Then
	MOVF 0x023,W
	SUBLW 0x00
	BTFSC STATUS,C
	GOTO L0031
; 166: halltime2 = halltime2 - 1
	DECF 0x023,F
; 167: Else
	GOTO L0032
L0031:
; 168: fb2 = 1
	BSF PORTB,5
; 169: Endif
L0032:
; 170: If halltime3 > 0 Then
	MOVF 0x024,W
	SUBLW 0x00
	BTFSC STATUS,C
	GOTO L0033
; 171: halltime3 = halltime3 - 1
	DECF 0x024,F
; 172: Else
	GOTO L0034
L0033:
; 173: fb3 = 1
	BSF PORTB,6
; 174: Endif
L0034:
; 175: If halltime4 > 0 Then
	MOVF 0x025,W
	SUBLW 0x00
	BTFSC STATUS,C
	GOTO L0035
; 176: halltime4 = halltime4 - 1
	DECF 0x025,F
; 177: Else
	GOTO L0036
L0035:
; 178: fb4 = 1
	BSF PORTB,7
; 179: Endif
L0036:
; 180: If halltime5 > 0 Then
	MOVF 0x026,W
	SUBLW 0x00
	BTFSC STATUS,C
	GOTO L0037
; 181: halltime5 = halltime5 - 1
	DECF 0x026,F
; 182: Else
	GOTO L0038
L0037:
; 183: fb5 = 1
	BSF PORTB,3
; 184: Endif
L0038:
; 185: If halltime6 > 0 Then
	MOVF 0x027,W
	SUBLW 0x00
	BTFSC STATUS,C
	GOTO L0039
; 186: halltime6 = halltime6 - 1
	DECF 0x027,F
; 187: Else
	GOTO L0040
L0039:
; 188: fb6 = 1
	BSF PORTB,2
; 189: Endif
L0040:
; 190: If halltime7 > 0 Then
	MOVF 0x02A,W
	SUBLW 0x00
	BTFSC STATUS,C
	GOTO L0041
; 191: halltime7 = halltime7 - 1
	DECF 0x02A,F
; 192: Else
	GOTO L0042
L0041:
; 193: fb7 = 1
	BSF PORTB,1
; 194: Endif
L0042:
; 195: If halltime8 > 0 Then
	MOVF 0x02B,W
	SUBLW 0x00
	BTFSC STATUS,C
	GOTO L0043
; 196: halltime8 = halltime8 - 1
	DECF 0x02B,F
; 197: Else
	GOTO L0044
L0043:
; 198: fb8 = 1
	BSF PORTB,0
; 199: Endif
L0044:
; 200: Endif
L0028:
; 201: Goto main
	GOTO L0001
; 202: 
; 203: End
L0045:	GOTO L0045
; 204: On Interrupt
L0003:
; 205: clock = clock + 1
	INCF 0x02C,F
; 206: INTCON.T0IF = 0  'enable new TMR0 interrupts
	BCF INTCON,2
; 207: Resume
	RETURN
; 208: 
; End of user code
L0046:	GOTO L0046
;
;
; Delay Routine Byte
; minimal routine execution time: 8s
; routine execution time step: 3s
; maximal routine execution time: 770s
DL01:
	DECFSZ R4L,F
	GOTO DL01
	RETURN
; Delay Routine Word
; minimal routine execution time: 15s
; routine execution time step: 10s
; maximal routine execution time: 655365s
DL02:
	MOVLW 0x01
	SUBWF R4L,F
	CLRW
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF R4H,F
	BTFSS STATUS,C
	RETURN
	GOTO DL02
; Waitms Routine
W001:	MOVLW 0x01
	SUBWF R0L,F
	CLRW
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF R0H,F
	BTFSS STATUS,C
	RETURN
	MOVLW 0x61
	MOVWF R4L
	MOVLW 0x00
	MOVWF R4H
	CALL DL02
	GOTO W001
;
;
;
;
; Configuration settings
	ORG 0x2007
	DW 0x3F50
; End of listing
	END
