; Compiled with: PIC Simulator IDE v7.19
; Microcontroller model: PIC16F628A
; Clock frequency: 4.0MHz
;
	R0L EQU 0x020
	R0H EQU 0x021
	R1L EQU 0x022
	R1H EQU 0x023
	R4L EQU 0x028
	R4H EQU 0x029
	R0HL EQU 0x020
	R1HL EQU 0x022
	R4HL EQU 0x028
	R1HL0HL EQU 0x020
;       The address of 'servo_value' (word) (global) is 0x025
;       The address of 'old_servo_1' (bit) (global) is 0x02D,6
;       The address of 'old_servo_2' (bit) (global) is 0x02D,7
;       The address of 'flashtime' (byte) (global) is 0x027
;       The address of 'rel_off_delay' (byte) (global) is 0x02C
;       The address of 'old_hall_a' (bit) (global) is 0x02D,0
;       The address of 'old_hall_b' (bit) (global) is 0x02D,1
;       The address of 'old_hall_c' (bit) (global) is 0x02D,2
;       The address of 'old_hall_d' (bit) (global) is 0x02D,3
;       The address of 'count_enter_a' (byte) (global) is 0x02A
;       The address of 'count_enter_d' (byte) (global) is 0x02B
;       The address of 'count_down_a_to_d' (byte) (global) is 0x02E
;       The address of 'count_down_d_to_a' (byte) (global) is 0x02F
;       The address of 'program' (byte) (global) is 0x024
;       The address of 'track_a_to_b_occ' (bit) (global) is 0x02D,4
;       The address of 'track_d_to_c_occ' (bit) (global) is 0x02D,5
;       The address of 'hall_a' (bit) (global) is 0x005,6
;       The address of 'hall_b' (bit) (global) is 0x005,7
;       The address of 'hall_c' (bit) (global) is 0x005,0
;       The address of 'hall_d' (bit) (global) is 0x005,1
;       The address of 'servo_1' (bit) (global) is 0x006,5
;       The address of 'servo_2' (bit) (global) is 0x006,4
;       The address of 'flash_1' (bit) (global) is 0x006,3
;       The address of 'flash_2' (bit) (global) is 0x006,2
;       The address of 'rel' (bit) (global) is 0x006,1
	ORG 0x0000
	BCF PCLATH,4
	BCF PCLATH,3
	GOTO L0003
	ORG 0x0004
	RETFIE
; User code start
L0003:
; 1: 
; 2: 
; 3: 'program GCA186
; 4: 'railroad crossing controller for two TRACKS both in one direction
; 5: Define CONF_WORD = 0x3f50
; 6: 
; 7: CMCON = 7
	MOVLW 0x07
	MOVWF CMCON
; 8: TRISA = 255
	MOVLW 0xFF
	BSF STATUS,RP0
	MOVWF TRISA
; 9: TRISB = 0
	CLRF TRISB
	BCF STATUS,RP0
; 10: PORTB = 0
	CLRF PORTB
; 11: AllDigital
	MOVLW 0x07
	MOVWF CMCON
; 12: 
; 13: Symbol hall_a = RA6
; 14: Symbol hall_b = RA7
; 15: Symbol hall_c = RA0
; 16: Symbol hall_d = RA1
; 17: Symbol servo_1 = RB5
; 18: Symbol servo_2 = RB4
; 19: Dim servo_value As Word
; 20: Dim old_servo_1 As Bit
; 21: Dim old_servo_2 As Bit
; 22: Symbol flash_1 = RB3
; 23: Symbol flash_2 = RB2
; 24: Dim flashtime As Byte
; 25: Dim rel_off_delay As Byte
; 26: Symbol rel = RB1
; 27: Dim old_hall_a As Bit
; 28: Dim old_hall_b As Bit
; 29: Dim old_hall_c As Bit
; 30: Dim old_hall_d As Bit
; 31: Dim count_enter_a As Byte
; 32: Dim count_enter_d As Byte
; 33: Dim count_down_a_to_d As Byte
; 34: Dim count_down_d_to_a As Byte
; 35: Dim program As Byte
; 36: Dim track_a_to_b_occ As Bit
; 37: Dim track_d_to_c_occ As Bit
; 38: old_hall_a = 0
	BCF 0x02D,0
; 39: old_hall_b = 0
	BCF 0x02D,1
; 40: old_hall_c = 0
	BCF 0x02D,2
; 41: old_hall_d = 0
	BCF 0x02D,3
; 42: old_servo_1 = 0
	BCF 0x02D,6
; 43: old_servo_2 = 0
	BCF 0x02D,7
; 44: count_down_a_to_d = 0
	CLRF 0x02E
; 45: count_down_d_to_a = 0
	CLRF 0x02F
; 46: count_enter_a = 0
	CLRF 0x02A
; 47: count_enter_d = 0
	CLRF 0x02B
; 48: track_a_to_b_occ = 0
	BCF 0x02D,4
; 49: track_d_to_c_occ = 0
	BCF 0x02D,5
; 50: 'program option":
; 51: 'program = 0  idle task
; 52: '_         1  entered a 'start activation of barriers and counting a
; 53: '_         2  BARRIERS ARE DOWN, wait loop before shutt off sound
; 54: '_         3  activated a or d 'start counting down
; 55: '_         4  counted to zero, start freeing barriers,
; 56: 
; 57: servo_value = 800  'start in barrier up position
	MOVLW 0x20
	MOVWF 0x025
	MOVLW 0x03
	MOVWF 0x026
; 58: For flashtime = 1 To 20
	MOVLW 0x01
	MOVWF 0x027
L0004:
	MOVF 0x027,W
	SUBLW 0x14
	BTFSS STATUS,C
	GOTO L0005
; 59: Gosub flashing
	CALL L0002
; 60: WaitMs 100
	MOVLW 0x0E
	MOVWF R4L
	MOVLW 0x27
	MOVWF R4H
	CALL DL02
; 61: Next flashtime
	MOVLW 0x01
	ADDWF 0x027,F
	BTFSS STATUS,C
	GOTO L0004
L0005:
; 62: program = 0
	CLRF 0x024
; 63: main:
L0001:
; 64: If hall_a = 0 Then
	BTFSC 0x005,6
	GOTO L0006
; 65: If old_hall_a = 0 Then
	BTFSC 0x02D,0
	GOTO L0007
; 66: old_hall_a = 1  'only one time reaction on hall_a
	BSF 0x02D,0
; 67: If count_enter_a = 0 Then  'no matter what program, start again
	MOVF 0x02A,W
	SUBLW 0x00
	BTFSS STATUS,Z
	GOTO L0008
; 68: program = 1
	MOVLW 0x01
	MOVWF 0x024
; 69: Endif
L0008:
; 70: count_enter_a = count_enter_a + 1
	MOVF 0x02A,W
	ADDLW 0x01
	MOVWF 0x02A
; 71: track_a_to_b_occ = 1
	BSF 0x02D,4
; 72: Endif
L0007:
; 73: Else
	GOTO L0009
L0006:
; 74: old_hall_a = 0
	BCF 0x02D,0
; 75: Endif
L0009:
; 76: If hall_d = 0 Then
	BTFSC 0x005,1
	GOTO L0010
; 77: If old_hall_d = 0 Then
	BTFSC 0x02D,3
	GOTO L0011
; 78: old_hall_d = 1  'only one time reaction on hall_d
	BSF 0x02D,3
; 79: If count_enter_d = 0 Then  'no matter what program, start again
	MOVF 0x02B,W
	SUBLW 0x00
	BTFSS STATUS,Z
	GOTO L0012
; 80: program = 1
	MOVLW 0x01
	MOVWF 0x024
; 81: Endif
L0012:
; 82: count_enter_d = count_enter_d + 1
	MOVF 0x02B,W
	ADDLW 0x01
	MOVWF 0x02B
; 83: track_d_to_c_occ = 1
	BSF 0x02D,5
; 84: Endif
L0011:
; 85: Else
	GOTO L0013
L0010:
; 86: old_hall_d = 0
	BCF 0x02D,3
; 87: Endif
L0013:
; 88: If hall_b = 0 Then
	BTFSC 0x005,7
	GOTO L0014
; 89: If old_hall_b = 0 Then
	BTFSC 0x02D,1
	GOTO L0015
; 90: old_hall_b = 1  'only one time reaction on hall_c
	BSF 0x02D,1
; 91: If count_enter_a > 0 Then
	MOVF 0x02A,W
	SUBLW 0x00
	BTFSC STATUS,C
	GOTO L0016
; 92: count_enter_a = count_enter_a - 1
	MOVLW 0x01
	SUBWF 0x02A,W
	MOVWF 0x02A
; 93: Else
	GOTO L0017
L0016:
; 94: track_a_to_b_occ = 0
	BCF 0x02D,4
; 95: Endif
L0017:
; 96: Endif
L0015:
; 97: Else
	GOTO L0018
L0014:
; 98: old_hall_b = 0
	BCF 0x02D,1
; 99: Endif
L0018:
; 100: If hall_c = 0 Then
	BTFSC 0x005,0
	GOTO L0019
; 101: If old_hall_c = 0 Then
	BTFSC 0x02D,2
	GOTO L0020
; 102: old_hall_c = 1  'only one time reaction on hall_b
	BSF 0x02D,2
; 103: If count_enter_d > 0 Then
	MOVF 0x02B,W
	SUBLW 0x00
	BTFSC STATUS,C
	GOTO L0021
; 104: count_enter_d = count_enter_d - 1
	MOVLW 0x01
	SUBWF 0x02B,W
	MOVWF 0x02B
; 105: Else
	GOTO L0022
L0021:
; 106: track_d_to_c_occ = 0
	BCF 0x02D,5
; 107: Endif
L0022:
; 108: Endif
L0020:
; 109: Else
	GOTO L0023
L0019:
; 110: old_hall_c = 0
	BCF 0x02D,2
; 111: Endif
L0023:
; 112: Select Case program
; 113: Case 0
	MOVF 0x024,W
	SUBLW 0x00
	BTFSS STATUS,Z
	GOTO L0024
; 114: flash_1 = 1
	BSF PORTB,3
; 115: flash_2 = 0
	BCF PORTB,2
; 116: Case 1  'starting barriers close
	GOTO L0025
L0024:
	MOVF 0x024,W
	SUBLW 0x01
	BTFSS STATUS,Z
	GOTO L0026
; 117: rel = 0  'ACTIVATE SOUND
	BCF PORTB,1
; 118: rel_off_delay = 80
	MOVLW 0x50
	MOVWF 0x02C
; 119: If servo_value < 2196 Then
	MOVF 0x025,W
	MOVWF R0L
	MOVF 0x026,W
	MOVWF R0H
	MOVLW 0x94
	MOVWF R1L
	MOVLW 0x08
	MOVWF R1H
	CALL C004
	BTFSS STATUS,Z
	GOTO L0027
; 120: servo_value = servo_value + 3
	MOVF 0x025,W
	ADDLW 0x03
	MOVWF 0x025
	MOVF 0x026,W
	BTFSC STATUS,C
	ADDLW 0x01
	ADDLW 0x00
	MOVWF 0x026
; 121: servo_1 = 1
	BSF PORTB,5
; 122: WaitUs servo_value
	MOVF 0x025,W
	MOVWF R4L
	MOVF 0x026,W
	MOVWF R4H
	CALL Y001
; 123: servo_1 = 0
	BCF PORTB,5
; 124: servo_2 = 1
	BSF PORTB,4
; 125: WaitUs servo_value
	MOVF 0x025,W
	MOVWF R4L
	MOVF 0x026,W
	MOVWF R4H
	CALL Y001
; 126: servo_2 = 0
	BCF PORTB,4
; 127: WaitMs 15
	MOVLW 0xDA
	MOVWF R4L
	MOVLW 0x05
	MOVWF R4H
	CALL DL02
; 128: Else
	GOTO L0028
L0027:
; 129: program = 2
	MOVLW 0x02
	MOVWF 0x024
; 130: WaitMs 20
	MOVLW 0xCE
	MOVWF R4L
	MOVLW 0x07
	MOVWF R4H
	CALL DL02
; 131: Endif
L0028:
; 132: Case 2  'waiting for sound to switch off
	GOTO L0029
L0026:
	MOVF 0x024,W
	SUBLW 0x02
	BTFSS STATUS,Z
	GOTO L0030
; 133: If rel_off_delay > 0 Then
	MOVF 0x02C,W
	SUBLW 0x00
	BTFSC STATUS,C
	GOTO L0031
; 134: rel_off_delay = rel_off_delay - 1
	MOVLW 0x01
	SUBWF 0x02C,W
	MOVWF 0x02C
; 135: Else
	GOTO L0032
L0031:
; 136: rel = 1  'sound off
	BSF PORTB,1
; 137: program = program + 1
	MOVF 0x024,W
	ADDLW 0x01
	MOVWF 0x024
; 138: Endif
L0032:
; 139: WaitMs 20
	MOVLW 0xCE
	MOVWF R4L
	MOVLW 0x07
	MOVWF R4H
	CALL DL02
; 140: Case 3  'now waiting For the Count doen
	GOTO L0033
L0030:
	MOVF 0x024,W
	SUBLW 0x03
	BTFSS STATUS,Z
	GOTO L0034
; 141: If track_d_to_c_occ = 0 Then
	BTFSC 0x02D,5
	GOTO L0035
; 142: If track_a_to_b_occ = 0 Then
	BTFSC 0x02D,4
	GOTO L0036
; 143: program = 4
	MOVLW 0x04
	MOVWF 0x024
; 144: Endif
L0036:
; 145: Endif
L0035:
; 146: Case 4
	GOTO L0037
L0034:
	MOVF 0x024,W
	SUBLW 0x04
	BTFSS STATUS,Z
	GOTO L0038
; 147: If servo_value > 804 Then
	MOVF 0x025,W
	MOVWF R0L
	MOVF 0x026,W
	MOVWF R0H
	MOVLW 0x24
	MOVWF R1L
	MOVLW 0x03
	MOVWF R1H
	CALL C003
	BTFSS STATUS,Z
	GOTO L0039
; 148: servo_value = servo_value - 3
	MOVLW 0x03
	SUBWF 0x025,W
	MOVWF 0x025
	MOVLW 0x00
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x026,W
	MOVWF 0x026
; 149: servo_1 = 1
	BSF PORTB,5
; 150: WaitUs servo_value
	MOVF 0x025,W
	MOVWF R4L
	MOVF 0x026,W
	MOVWF R4H
	CALL Y001
; 151: servo_1 = 0
	BCF PORTB,5
; 152: servo_2 = 1
	BSF PORTB,4
; 153: WaitUs servo_value
	MOVF 0x025,W
	MOVWF R4L
	MOVF 0x026,W
	MOVWF R4H
	CALL Y001
; 154: servo_2 = 0
	BCF PORTB,4
; 155: WaitMs 15
	MOVLW 0xDA
	MOVWF R4L
	MOVLW 0x05
	MOVWF R4H
	CALL DL02
; 156: Else
	GOTO L0040
L0039:
; 157: WaitMs 20
	MOVLW 0xCE
	MOVWF R4L
	MOVLW 0x07
	MOVWF R4H
	CALL DL02
; 158: program = 0
	CLRF 0x024
; 159: Endif
L0040:
; 160: Case Else
	GOTO L0041
L0038:
; 161: WaitMs 20
	MOVLW 0xCE
	MOVWF R4L
	MOVLW 0x07
	MOVWF R4H
	CALL DL02
; 162: EndSelect
L0041:
L0037:
L0033:
L0029:
L0025:
; 163: Gosub flashing
	CALL L0002
; 164: Goto main
	GOTO L0001
; 165: End
L0042:	GOTO L0042
; 166: 
; 167: flashing:
L0002:
; 168: Select Case program
; 169: Case 0
	MOVF 0x024,W
	SUBLW 0x00
	BTFSS STATUS,Z
	GOTO L0043
; 170: flash_1 = 1
	BSF PORTB,3
; 171: flash_2 = 0
	BCF PORTB,2
; 172: Case Else
	GOTO L0044
L0043:
; 173: If flashtime < 24 Then
	MOVLW 0x18
	SUBWF 0x027,W
	BTFSC STATUS,C
	GOTO L0045
; 174: flashtime = flashtime + 1
	MOVF 0x027,W
	ADDLW 0x01
	MOVWF 0x027
; 175: Else
	GOTO L0046
L0045:
; 176: flashtime = 0
	CLRF 0x027
; 177: flash_1 = flash_2
	BTFSC PORTB,2
	BSF PORTB,3
	BTFSS PORTB,2
	BCF PORTB,3
; 178: flash_2 = Not flash_1
	BTFSS 0x006,3
	BSF 0x006,2
	BTFSC 0x006,3
	BCF 0x006,2
; 179: Endif
L0046:
; 180: EndSelect
L0044:
; 181: Return
	RETURN
; End of user code
L0047:	GOTO L0047
; Delay Routine Byte
; minimal routine execution time: 8s
; routine execution time step: 3s
; maximal routine execution time: 770s
DL01:
	DECFSZ R4L,F
	GOTO DL01
	RETURN
; Delay Routine Word
; minimal routine execution time: 15s
; routine execution time step: 10s
; maximal routine execution time: 655365s
DL02:
	MOVLW 0x01
	SUBWF R4L,F
	CLRW
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF R4H,F
	BTFSS STATUS,C
	RETURN
	GOTO DL02
; Waitms Routine
W001:	MOVLW 0x01
	SUBWF R0L,F
	CLRW
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF R0H,F
	BTFSS STATUS,C
	RETURN
	MOVLW 0x61
	MOVWF R4L
	MOVLW 0x00
	MOVWF R4H
	CALL DL02
	GOTO W001
; Waitus Routine Word
; minimal routine execution time: 15s
; routine execution time step: 10s
Y001:	MOVLW 0x10
	SUBWF R4L,F
	CLRW
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF R4H,F
	BTFSS STATUS,C
	RETURN
Y002:	MOVLW 0x0A
	SUBWF R4L,F
	CLRW
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF R4H,F
	BTFSS STATUS,C
	RETURN
	GOTO Y002
; Word Comparison Routine
C001:	MOVLW 0x05
	GOTO C007
C002:	MOVLW 0x02
	GOTO C007
C003:	MOVLW 0x06
	GOTO C007
C004:	MOVLW 0x03
	GOTO C007
C005:	MOVLW 0x04
	GOTO C007
C006:	MOVLW 0x01
C007:	MOVWF R4L
	MOVF R1H,W
	SUBWF R0H,W
	BTFSS STATUS,Z
	GOTO C008
	MOVF R1L,W
	SUBWF R0L,W
C008:	MOVLW 0x04
	BTFSC STATUS,C
	MOVLW 0x01
	BTFSC STATUS,Z
	MOVLW 0x02
	ANDWF R4L,W
	BTFSS STATUS,Z
	MOVLW 0xFF
	RETURN
;
;
;
;
; Configuration settings
	ORG 0x2007
	DW 0x3F50
; End of listing
	END
