; Compiled with: PIC Simulator IDE v7.25
; Microcontroller model: PIC12F675
; Clock frequency: 4.0MHz
;
	R0L EQU 0x020
	R0H EQU 0x021
	R1L EQU 0x022
	R1H EQU 0x023
	R4L EQU 0x028
	R4H EQU 0x029
	R0HL EQU 0x020
	R1HL EQU 0x022
	R4HL EQU 0x028
	R1HL0HL EQU 0x020
;       The value of 'max_count' (global) is 60
;       The value of 'max_short_count' (global) is 3000
;       The address of 'short_count1' (word) (global) is 0x025
;       The address of 'short_count2' (word) (global) is 0x02E
;       The address of 'short_time' (byte) (global) is 0x02D
;       The address of 'no_pulse_count1' (byte) (global) is 0x027
;       The address of 'analog_value' (word) (global) is 0x030
;       The address of 'max_current' (word) (global) is 0x02A
;       The address of 'ok_state' (byte) (global) is 0x024
;       The address of 'old_p1' (bit) (global) is 0x02C,0
;       The address of 'p1' (bit) (global) is 0x005,3
;       The address of 'cut_out' (bit) (global) is 0x005,2
;       The address of 'l6203_enable' (bit) (global) is 0x005,4
;       The address of 'booster_on' (bit) (global) is 0x005,5
	ORG 0x0000
	BCF PCLATH,4
	BCF PCLATH,3
	GOTO L0004
	ORG 0x0004
	RETFIE
; User code start
L0004:
; 1: 'program for ORD-3 Spax booster / DDX Booster
; 2: 'this edition accept dc based pulses
; 3: 'special version for slow computers
; 4: Define CONF_WORD = 0x31c4
; 5: 
; 6: AllDigital
	BSF STATUS,RP0
	CLRF ANSEL
	MOVLW 0x07
	BCF STATUS,RP0
	MOVWF CMCON
; 7: ANSEL.ANS0 = 1
	BSF STATUS,RP0
	BSF ANSEL,0
; 8: ANSEL.ANS1 = 0
	BCF ANSEL,1
; 9: ANSEL.ANS2 = 0
	BCF ANSEL,2
; 10: ANSEL.ANS3 = 0
	BCF ANSEL,3
	BCF STATUS,RP0
; 11: 
; 12: ADCON0.ADON = 1
	BSF ADCON0,0
; 13: ADCON0.VCFG = 0
	BCF ADCON0,6
; 14: 
; 15: TRISIO = %001011
	MOVLW 0x0B
	BSF STATUS,RP0
	MOVWF TRISIO
	BCF STATUS,RP0
; 16: 
; 17: Dim short_count1 As Word
; 18: Dim short_count2 As Word
; 19: Dim short_time As Byte
; 20: Dim no_pulse_count1 As Byte
; 21: Dim analog_value As Word
; 22: Dim max_current As Word
; 23: Dim ok_state As Byte
; 24: Symbol p1 = GP3
; 25: Symbol cut_out = GP2
; 26: Dim old_p1 As Bit
; 27: Symbol l6203_enable = GP4
; 28: Symbol booster_on = GP5
; 29: Const max_count = 60  '60 mSec no pulses received before booster is off
; 30: Const max_short_count = 3000
; 31: l6203_enable = 0  'system off
	BCF GPIO,4
; 32: short_count1 = 0
	CLRF 0x025
	CLRF 0x026
; 33: short_time = 0
	CLRF 0x02D
; 34: no_pulse_count1 = 0
	CLRF 0x027
; 35: booster_on = 1
	BSF GPIO,5
; 36: ok_state = 0
	CLRF 0x024
; 37: WaitMs 1000
	MOVLW 0xE8
	MOVWF R0L
	MOVLW 0x03
	MOVWF R0H
	CALL W001
; 38: Gosub check_jumper
	CALL L0003
; 39: cut_out = 1  'this should be 0 in cut-out sequence ( l6203_enable remains 1 )
	BSF GPIO,2
; 40: main:
L0001:
; 41: WaitUs 850  'Total loop time of program when no pulses are coming in
	MOVLW 0x53
	MOVWF R4L
	MOVLW 0x00
	MOVWF R4H
	CALL DL02
; 42: '*                 = 150 us. We need timing of 1 mSec
; 43: Gosub check_l6203
	CALL L0002
; 44: If ok_state.2 = 1 Then
	BTFSS 0x024,2
	GOTO L0005
; 45: If short_count1 > 0 Then
	MOVF 0x025,W
	MOVWF R0L
	MOVF 0x026,W
	MOVWF R0H
	CLRF R1L
	CLRF R1H
	CALL C003
	BTFSS STATUS,Z
	GOTO L0006
; 46: short_count1 = short_count1 - 1
	MOVLW 0x01
	SUBWF 0x025,W
	MOVWF 0x025
	MOVLW 0x00
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x026,W
	MOVWF 0x026
; 47: Else
	GOTO L0007
L0006:
; 48: ok_state.2 = 0
	BCF 0x024,2
; 49: Endif
L0007:
; 50: Endif
L0005:
; 51: If p1 <> old_p1 Then
	CLRW
	BTFSC 0x005,3
	ADDLW 0x01
	BTFSC 0x02C,0
	SUBLW 0x01
	BTFSC STATUS,Z
	GOTO L0008
; 52: old_p1 = p1
	BCF 0x02C,0
	BTFSC GPIO,3
	BSF 0x02C,0
; 53: ok_state.0 = 0
	BCF 0x024,0
; 54: no_pulse_count1 = 0
	CLRF 0x027
; 55: Else
	GOTO L0009
L0008:
; 56: no_pulse_count1 = no_pulse_count1 + 1
	MOVF 0x027,W
	ADDLW 0x01
	MOVWF 0x027
; 57: If no_pulse_count1 = max_count Then
	MOVF 0x027,W
	SUBLW 0x3C
	BTFSS STATUS,Z
	GOTO L0010
; 58: no_pulse_count1 = max_count
	MOVLW 0x3C
	MOVWF 0x027
; 59: ok_state.0 = 1
	BSF 0x024,0
; 60: Endif
L0010:
; 61: Endif
L0009:
; 62: Select Case ok_state
; 63: Case 0  'no problem found
	MOVF 0x024,W
	SUBLW 0x00
	BTFSS STATUS,Z
	GOTO L0011
; 64: l6203_enable = 1  'power on booster
	BSF GPIO,4
; 65: booster_on = 0
	BCF GPIO,5
; 66: Case Else  'there is a problem
	GOTO L0012
L0011:
; 67: l6203_enable = 0  'power off booster
	BCF GPIO,4
; 68: booster_on = 1
	BSF GPIO,5
; 69: EndSelect
L0012:
; 70: Goto main
	GOTO L0001
; 71: End
L0013:	GOTO L0013
; 72: 
; 73: check_l6203:
L0002:
; 74: Adcin 0, analog_value  'measure currect
	BSF ADCON0,ADFM
	BSF STATUS,RP0
	MOVLW 0x30
	IORWF ANSEL,F
	BCF STATUS,RP0
	CLRF R0L
	CALL A001
	BSF STATUS,RP0
	MOVF ADRESL,W
	BCF STATUS,RP0
	MOVWF 0x030
	MOVF ADRESH,W
	MOVWF 0x031
; 75: If analog_value > max_current Then
	MOVF 0x030,W
	MOVWF R0L
	MOVF 0x031,W
	MOVWF R0H
	MOVF 0x02A,W
	MOVWF R1L
	MOVF 0x02B,W
	MOVWF R1H
	CALL C003
	BTFSS STATUS,Z
	GOTO L0014
; 76: If short_count1 < 500 Then  '500 times too high = after 0,5 second
	MOVF 0x025,W
	MOVWF R0L
	MOVF 0x026,W
	MOVWF R0H
	MOVLW 0xF4
	MOVWF R1L
	MOVLW 0x01
	MOVWF R1H
	CALL C004
	BTFSS STATUS,Z
	GOTO L0015
; 77: short_count1 = short_count1 + 1
	MOVF 0x025,W
	ADDLW 0x01
	MOVWF 0x025
	MOVF 0x026,W
	BTFSC STATUS,C
	ADDLW 0x01
	ADDLW 0x00
	MOVWF 0x026
; 78: Else
	GOTO L0016
L0015:
; 79: short_count2 = 2500  'delay 5 seconce before next try
	MOVLW 0xC4
	MOVWF 0x02E
	MOVLW 0x09
	MOVWF 0x02F
; 80: ok_state.2 = 1  'indicate power should be off
	BSF 0x024,2
; 81: Endif
L0016:
; 82: Endif
L0014:
; 83: Return
	RETURN
; 84: 
; 85: check_jumper:
L0003:
; 86: If GP1 = 1 Then
	BTFSS 0x005,1
	GOTO L0017
; 87: max_current = 240  '~~ (Analog_value * 1023)/Vref  = 0,33Ohm x 3,5 Amp x 1023 / 5
	MOVLW 0xF0
	MOVWF 0x02A
	CLRF 0x02B
; 88: Else
	GOTO L0018
L0017:
; 89: max_current = 80  '~~ (Analog_value * 1023)/Vref  = 0,33Ohm x 1,1 Amp x 1023 / 5
	MOVLW 0x50
	MOVWF 0x02A
	CLRF 0x02B
; 90: Endif
L0018:
; 91: Return
	RETURN
; 92: 
; 93: 
; End of user code
L0019:	GOTO L0019
;
;
; Delay Routine Byte
; minimal routine execution time: 8s
; routine execution time step: 3s
; maximal routine execution time: 770s
DL01:
	DECFSZ R4L,F
	GOTO DL01
	RETURN
; Delay Routine Word
; minimal routine execution time: 15s
; routine execution time step: 10s
; maximal routine execution time: 655365s
DL02:
	MOVLW 0x01
	SUBWF R4L,F
	CLRW
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF R4H,F
	BTFSS STATUS,C
	RETURN
	GOTO DL02
; Waitms Routine
W001:	MOVLW 0x01
	SUBWF R0L,F
	CLRW
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF R0H,F
	BTFSS STATUS,C
	RETURN
	MOVLW 0x61
	MOVWF R4L
	MOVLW 0x00
	MOVWF R4H
	CALL DL02
	GOTO W001
; Word Comparison Routine
C001:	MOVLW 0x05
	GOTO C007
C002:	MOVLW 0x02
	GOTO C007
C003:	MOVLW 0x06
	GOTO C007
C004:	MOVLW 0x03
	GOTO C007
C005:	MOVLW 0x04
	GOTO C007
C006:	MOVLW 0x01
C007:	MOVWF R4L
	MOVF R1H,W
	SUBWF R0H,W
	BTFSS STATUS,Z
	GOTO C008
	MOVF R1L,W
	SUBWF R0L,W
C008:	MOVLW 0x04
	BTFSC STATUS,C
	MOVLW 0x01
	BTFSC STATUS,Z
	MOVLW 0x02
	ANDWF R4L,W
	BTFSS STATUS,Z
	MOVLW 0xFF
	RETURN
; Adcin Routine
A001:	RLF R0L,F
	RLF R0L,F
	MOVLW 0x3C
	ANDWF R0L,F
	MOVLW 0xC0
	ANDWF ADCON0,F
	MOVF R0L,W
	IORWF ADCON0,F
	BSF ADCON0,ADON
	MOVLW 0x05
	MOVWF R4L
	CALL DL01
	BSF ADCON0,GO
A002:
	BTFSC ADCON0,GO
	GOTO A002
	BCF PIR1,ADIF
	BCF ADCON0,ADON
	RETURN
;
;
; Configuration settings
	ORG 0x2007
	DW 0x31C4
; End of listing
	END
