; Compiled with: PIC Simulator IDE v7.42
; Microcontroller model: PIC12F675
; Clock frequency: 4.0MHz
;
	R0L EQU 0x020
	R0H EQU 0x021
	R1L EQU 0x022
	R1H EQU 0x023
	R4L EQU 0x028
	R4H EQU 0x029
	R0HL EQU 0x020
	R1HL EQU 0x022
	R4HL EQU 0x028
	R1HL0HL EQU 0x020
	LONG_0 EQU 0x02A
	LONG_1 EQU 0x02B
	LONG_2 EQU 0x02C
	LONG_3 EQU 0x02D
	LONG2_0 EQU 0x02E
	LONG2_1 EQU 0x02F
	LONG2_2 EQU 0x030
	LONG2_3 EQU 0x031
	LONG1 EQU 0x02A
	LONG2 EQU 0x02E
;       The value of 'max_count' (global) is 30
;       The value of 'max_short_count' (global) is 3000
;       The address of 'short_count' (word) (global) is 0x032
;       The address of 'short_time' (word) (global) is 0x026
;       The address of 'no_pulse_count1' (byte) (global) is 0x025
;       The address of 'analog_value' (word) (global) is 0x037
;       The address of 'max_current' (word) (global) is 0x034
;       The address of 'ok_state' (byte) (global) is 0x024
;       The address of 'old_p1' (bit) (global) is 0x036,0
;       The address of 'p1' (bit) (global) is 0x005,3
;       The address of 'cut_out' (bit) (global) is 0x005,2
;       The address of 'l6203_enable' (bit) (global) is 0x005,4
;       The address of 'booster_on' (bit) (global) is 0x005,5
	ORG 0x0000
	BCF PCLATH,4
	BCF PCLATH,3
	GOTO L0004
	ORG 0x0004
	RETFIE
; User code start
L0004:
; 1: 'program for ORD-3 Spax booster / DDX Booster
; 2: 'this edition accept dc based pulses
; 3: Define CONF_WORD = 0x31c4
; 4: 
; 5: AllDigital
	BSF STATUS,RP0
	CLRF ANSEL
	MOVLW 0x07
	BCF STATUS,RP0
	MOVWF CMCON
; 6: ANSEL.ANS0 = 1
	BSF STATUS,RP0
	BSF ANSEL,0
; 7: ANSEL.ANS1 = 0
	BCF ANSEL,1
; 8: ANSEL.ANS2 = 0
	BCF ANSEL,2
; 9: ANSEL.ANS3 = 0
	BCF ANSEL,3
	BCF STATUS,RP0
; 10: 
; 11: ADCON0.ADON = 1
	BSF ADCON0,0
; 12: ADCON0.VCFG = 0
	BCF ADCON0,6
; 13: 
; 14: TRISIO = %001011
	MOVLW 0x0B
	BSF STATUS,RP0
	MOVWF TRISIO
	BCF STATUS,RP0
; 15: 
; 16: Dim short_count As Word
; 17: Dim short_time As Word
; 18: Dim no_pulse_count1 As Byte
; 19: Dim analog_value As Word
; 20: Dim max_current As Word
; 21: Dim ok_state As Byte
; 22: Symbol p1 = GP3
; 23: Symbol cut_out = GP2
; 24: Dim old_p1 As Bit
; 25: Symbol l6203_enable = GP4
; 26: Symbol booster_on = GP5
; 27: Const max_count = 30
; 28: Const max_short_count = 3000
; 29: l6203_enable = 0  'system off
	BCF GPIO,4
; 30: short_count = 0
	CLRF 0x032
	CLRF 0x033
; 31: short_time = 0
	CLRF 0x026
	CLRF 0x027
; 32: no_pulse_count1 = 0
	CLRF 0x025
; 33: booster_on = 1
	BSF GPIO,5
; 34: ok_state = 0
	CLRF 0x024
; 35: WaitMs 1000
	MOVLW 0xE8
	MOVWF R0L
	MOVLW 0x03
	MOVWF R0H
	CALL W001
; 36: Gosub check_jumper
	CALL L0003
; 37: cut_out = 1  'this should be 0 in cut-out sequence ( l6203_enable remains 1 )
	BSF GPIO,2
; 38: main:
L0001:
; 39: WaitUs 850  'Total loop time of program when no pulses are coming in
	MOVLW 0x53
	MOVWF R4L
	MOVLW 0x00
	MOVWF R4H
	CALL DL02
; 40: '*                 = 150 us. We need timing of 1 mSec
; 41: Gosub check_l6203
	CALL L0002
; 42: If ok_state.1 = 1 Then  'still in short circuit situation
	BTFSS 0x024,1
	GOTO L0005
; 43: If short_time > 0 Then  'count down
	MOVF 0x026,W
	MOVWF R0L
	MOVF 0x027,W
	MOVWF R0H
	CLRF R1L
	CLRF R1H
	CALL C003
	BTFSS STATUS,Z
	GOTO L0006
; 44: short_time = short_time - 1
	MOVLW 0x01
	SUBWF 0x026,W
	MOVWF 0x026
	MOVLW 0x00
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x027,W
	MOVWF 0x027
; 45: Else
	GOTO L0007
L0006:
; 46: ok_state.1 = 0  'short-circuit countdown has ended
	BCF 0x024,1
; 47: Endif
L0007:
; 48: Endif
L0005:
; 49: If p1 <> old_p1 Then
	CLRW
	BTFSC 0x005,3
	ADDLW 0x01
	BTFSC 0x036,0
	SUBLW 0x01
	BTFSC STATUS,Z
	GOTO L0008
; 50: old_p1 = p1
	BCF 0x036,0
	BTFSC GPIO,3
	BSF 0x036,0
; 51: ok_state.0 = 0
	BCF 0x024,0
; 52: no_pulse_count1 = 0
	CLRF 0x025
; 53: Else
	GOTO L0009
L0008:
; 54: no_pulse_count1 = no_pulse_count1 + 1
	MOVF 0x025,W
	ADDLW 0x01
	MOVWF 0x025
; 55: If no_pulse_count1 = max_count Then
	MOVF 0x025,W
	SUBLW 0x1E
	BTFSS STATUS,Z
	GOTO L0010
; 56: ok_state.0 = 1
	BSF 0x024,0
; 57: Endif
L0010:
; 58: Endif
L0009:
; 59: Select Case ok_state
; 60: Case 0  'no problem found
	MOVF 0x024,W
	SUBLW 0x00
	BTFSS STATUS,Z
	GOTO L0011
; 61: l6203_enable = 1  'power on booster
	BSF GPIO,4
; 62: booster_on = 0
	BCF GPIO,5
; 63: Case Else  'there is a problem
	GOTO L0012
L0011:
; 64: l6203_enable = 0  'power off booster
	BCF GPIO,4
; 65: booster_on = 1
	BSF GPIO,5
; 66: EndSelect
L0012:
; 67: Goto main
	GOTO L0001
; 68: End
L0013:	GOTO L0013
; 69: 
; 70: check_l6203:
L0002:
; 71: Adcin 0, analog_value  'measure currect
	BSF ADCON0,ADFM
	BSF STATUS,RP0
	MOVLW 0x30
	IORWF ANSEL,F
	BCF STATUS,RP0
	CLRF R0L
	CALL A001
	BSF STATUS,RP0
	MOVF ADRESL,W
	BCF STATUS,RP0
	MOVWF 0x037
	MOVF ADRESH,W
	MOVWF 0x038
; 72: If analog_value > max_current Then
	MOVF 0x037,W
	MOVWF R0L
	MOVF 0x038,W
	MOVWF R0H
	MOVF 0x034,W
	MOVWF R1L
	MOVF 0x035,W
	MOVWF R1H
	CALL C003
	BTFSS STATUS,Z
	GOTO L0014
; 73: If short_count < 250 Then  '250 times too high = after 0,25 second
	MOVF 0x032,W
	MOVWF R0L
	MOVF 0x033,W
	MOVWF R0H
	MOVLW 0xFA
	MOVWF R1L
	CLRF R1H
	CALL C004
	BTFSS STATUS,Z
	GOTO L0015
; 74: short_count = short_count + 1
	MOVF 0x032,W
	ADDLW 0x01
	MOVWF 0x032
	MOVF 0x033,W
	BTFSC STATUS,C
	ADDLW 0x01
	ADDLW 0x00
	MOVWF 0x033
; 75: Else  'now is time to shut off booster
	GOTO L0016
L0015:
; 76: short_time = 5000  'delay 5 seconce before next try
	MOVLW 0x88
	MOVWF 0x026
	MOVLW 0x13
	MOVWF 0x027
; 77: ok_state.1 = 1  'indicate power should be off
	BSF 0x024,1
; 78: Endif
L0016:
; 79: Endif
L0014:
; 80: Return
	RETURN
; 81: 
; 82: check_jumper:
L0003:
; 83: If GP1 = 1 Then
	BTFSS 0x005,1
	GOTO L0017
; 84: max_current = 240  '~~ (Analog_value * 1023)/Vref  = 0,33Ohm x 3,5 Amp x 1023 / 5
	MOVLW 0xF0
	MOVWF 0x034
	CLRF 0x035
; 85: Else
	GOTO L0018
L0017:
; 86: max_current = 80  '~~ (Analog_value * 1023)/Vref  = 0,33Ohm x 1,1 Amp x 1023 / 5
	MOVLW 0x50
	MOVWF 0x034
	CLRF 0x035
; 87: Endif
L0018:
; 88: Return
	RETURN
; 89: 
; 90: 
; End of user code
L0019:	GOTO L0019
;
;
; Delay Routine Byte
; minimal routine execution time: 8s
; routine execution time step: 3s
; maximal routine execution time: 770s
DL01:
	DECFSZ R4L,F
	GOTO DL01
	RETURN
; Delay Routine Word
; minimal routine execution time: 15s
; routine execution time step: 10s
; maximal routine execution time: 655365s
DL02:
	MOVLW 0x01
	SUBWF R4L,F
	CLRW
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF R4H,F
	BTFSS STATUS,C
	RETURN
	GOTO DL02
; Waitms Routine
W001:	MOVLW 0x01
	SUBWF R0L,F
	CLRW
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF R0H,F
	BTFSS STATUS,C
	RETURN
	MOVLW 0x61
	MOVWF R4L
	MOVLW 0x00
	MOVWF R4H
	CALL DL02
	GOTO W001
;
;
; Word Comparison Routine
C001:	MOVLW 0x05
	GOTO C007
C002:	MOVLW 0x02
	GOTO C007
C003:	MOVLW 0x06
	GOTO C007
C004:	MOVLW 0x03
	GOTO C007
C005:	MOVLW 0x04
	GOTO C007
C006:	MOVLW 0x01
C007:	MOVWF R4L
	MOVF R1H,W
	SUBWF R0H,W
	BTFSS STATUS,Z
	GOTO C008
	MOVF R1L,W
	SUBWF R0L,W
C008:	MOVLW 0x04
	BTFSC STATUS,C
	MOVLW 0x01
	BTFSC STATUS,Z
	MOVLW 0x02
	ANDWF R4L,W
	BTFSS STATUS,Z
	MOVLW 0xFF
	RETURN
; Adcin Routine
A001:	RLF R0L,F
	RLF R0L,F
	MOVLW 0x3C
	ANDWF R0L,F
	MOVLW 0xC0
	ANDWF ADCON0,F
	MOVF R0L,W
	IORWF ADCON0,F
	BSF ADCON0,ADON
	MOVLW 0x05
	MOVWF R4L
	CALL DL01
	BSF ADCON0,GO
A002:
	BTFSC ADCON0,GO
	GOTO A002
	BCF PIR1,ADIF
	BCF ADCON0,ADON
	RETURN
;
;
; Configuration settings
	ORG 0x2007
	DW 0x31C4
; End of listing
	END
