	list p=16f873
	#include <p16f873.inc>
	radix dec
; Compiled with: PIC Simulator IDE v6.71
; Microcontroller model: PIC16F873
; Clock frequency: 20.0 MHz
; Begin
	R0L EQU 0x20
	R0H EQU 0x21
	R1L EQU 0x22
	R1H EQU 0x23
	R2L EQU 0x24
	R2H EQU 0x25
	R3L EQU 0x26
	R3H EQU 0x27
	R4L EQU 0x28
	R4H EQU 0x29
	R5L EQU 0x2A
	R5H EQU 0x2B
	SCL_PORT EQU 0x2C
	SCL_BIT EQU 0x2D
	SDA_PORT EQU 0x2E
	SDA_BIT EQU 0x2F
	ORG 0x0000
	BCF PCLATH,3
	BCF PCLATH,4
	GOTO L0010
	ORG 0x0004
	RETFIE
L0010:
; 1: Define CONF_WORD = 0x3f72
; 2: 
; 3: 
; 4:  'Program MGV119 for PC-board MGV119
; 5:  'Design by P.H.Giling
; 6:  'This unit display time and ambient temperature by means of MGV118 mini led displays.
; 7:  'the interval is set to 3 seconds
; 8: 
; 9: ADCON1 = %0110
	BSF STATUS,RP0
	MOVLW 0x06
	MOVWF 0x1F
; 10: Symbol sda = PORTC.4
;       The address of 'sda' is 0x7,4
; 11: Symbol scl = PORTC.3
;       The address of 'scl' is 0x7,3
; 12: Symbol col0 = PORTC.0
;       The address of 'col0' is 0x7,0
; 13: Symbol col1 = PORTC.1
;       The address of 'col1' is 0x7,1
; 14: Symbol col2 = PORTC.2
;       The address of 'col2' is 0x7,2
; 15: Symbol col3 = PORTC.5
;       The address of 'col3' is 0x7,5
	BCF STATUS,RP0
; 16: Dim dis0 As Byte
;       The address of 'dis0' is 0x30
	dis0 EQU 0x30
; 17: Dim dis1 As Byte
;       The address of 'dis1' is 0x31
	dis1 EQU 0x31
; 18: Dim dis2 As Byte
;       The address of 'dis2' is 0x32
	dis2 EQU 0x32
; 19: Dim dis3 As Byte
;       The address of 'dis3' is 0x33
	dis3 EQU 0x33
; 20: Dim temp0 As Byte
;       The address of 'temp0' is 0x34
	temp0 EQU 0x34
; 21: Dim temp1 As Byte
;       The address of 'temp1' is 0x35
	temp1 EQU 0x35
; 22: Dim temperature As Byte
;       The address of 'temperature' is 0x36
	temperature EQU 0x36
; 23: Dim hour As Byte
;       The address of 'hour' is 0x37
	hour EQU 0x37
; 24: Dim minute As Byte
;       The address of 'minute' is 0x38
	minute EQU 0x38
; 25: Dim which_digit As Byte
;       The address of 'which_digit' is 0x39
	which_digit EQU 0x39
; 26: Dim teller As Byte
;       The address of 'teller' is 0x3A
	teller EQU 0x3A
; 27: Dim value As Byte
;       The address of 'value' is 0x3B
	value EQU 0x3B
; 28: Dim addr As Byte
;       The address of 'addr' is 0x3C
	addr EQU 0x3C
; 29: Dim disp_count As Word
;       The address of 'disp_count' is 0x3D
	disp_count EQU 0x3D
; 30: Dim disp As Byte
;       The address of 'disp' is 0x3F
	disp EQU 0x3F
; 31: Dim var1 As Byte
;       The address of 'var1' is 0x40
	var1 EQU 0x40
; 32: Dim var2 As Byte
;       The address of 'var2' is 0x41
	var2 EQU 0x41
; 33: Dim key_delay As Byte
;       The address of 'key_delay' is 0x42
	key_delay EQU 0x42
; 34: main: 
L0001:
; 35: TRISA = %011100
	BSF STATUS,RP0
	MOVLW 0x1C
	MOVWF 0x05
; 36: TRISB = %00000000
	CLRF 0x06
; 37: TRISC = %00000000
	CLRF 0x07
; 38: PORTA = %011100
	BCF STATUS,RP0
	MOVLW 0x1C
	MOVWF 0x05
; 39: PORTB = 0
	CLRF 0x06
; 40: PORTC = 0
	CLRF 0x07
; 41: I2CPrepare sda, scl
	MOVLW 0x07
	MOVWF SDA_PORT
	MOVLW 0x10
	MOVWF SDA_BIT
	BSF STATUS,RP0
	BCF TRISC,4
	BCF STATUS,RP0
	MOVLW 0x07
	MOVWF SCL_PORT
	MOVLW 0x08
	MOVWF SCL_BIT
	BSF STATUS,RP0
	BCF TRISC,3
	BCF STATUS,RP0
	CALL IC41
	CALL IC41
; 42: disp_count = 0
	CLRF 0x3D
	CLRF 0x3E
; 43: Read 0, value
	MOVLW 0x00
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x3B
; 44: If value = 255 Then 'chip running first time
	MOVF 0x3B,W
	SUBLW 0xFF
	BTFSS STATUS,Z
	GOTO L0011
; 45: Write 0, 0
	MOVLW 0x00
	BSF STATUS,RP1
	MOVWF EEADR
	MOVLW 0x00
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
L0012:	BTFSC EECON1,WR
	GOTO L0012
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 46: Gosub init_clock
	CALL L0009
; 47: Gosub init_temperature
	CALL L0008
; 48: I2CWrite sda, scl, addr, 0xaa, 2 'init temperature
	MOVLW 0x07
	MOVWF SDA_PORT
	MOVLW 0x10
	MOVWF SDA_BIT
	BSF STATUS,RP0
	BCF TRISC,4
	BCF STATUS,RP0
	MOVLW 0x07
	MOVWF SCL_PORT
	MOVLW 0x08
	MOVWF SCL_BIT
	BSF STATUS,RP0
	BCF TRISC,3
	BCF STATUS,RP0
	CALL IC41
	CALL IC41
	CALL IC31
	MOVF 0x3C,W
	ANDLW 0xFE
	CALL IC01
	MOVLW 0xAA
	CALL IC01
	MOVLW 0x02
	CALL IC01
	CALL IC41
; 49: WaitMs 10
	MOVLW 0x0A
	MOVWF R0L
	CLRF R0H
	CALL W001
; 50: 
; 51: Endif
L0011:	MOVLW 0x1F
	ANDWF STATUS,F
; 52: Gosub init_temperature
	CALL L0008
; 53: WaitMs 1000
	MOVLW 0xE8
	MOVWF R0L
	MOVLW 0x03
	MOVWF R0H
	CALL W001
; 54: Gosub read_temperature
	CALL L0004
; 55: Gosub read_clock
	CALL L0006
; 56: loop: 
L0002:
; 57: var1 = PORTA
	MOVF 0x05,W
	MOVWF 0x40
; 58:  'key positions
; 59:  'PORTA    result
; 60:  '28  no key pressed
; 61:  '24  h/m key is pressed
; 62:  '12 plus key only (minutes increas)
; 63:  '20 minus key pressed (minutes decrease)
; 64:  '16 minus key and h/m ley (decrease hours)
; 65:  '8 plus key and h/m key pressed (increase hours)
; 66: Select Case var1
; 67: Case 8
	MOVF 0x40,W
	SUBLW 0x08
	BTFSS STATUS,Z
	GOTO L0013
; 68: If key_delay = 0 Then
	MOVF 0x42,W
	SUBLW 0x00
	BTFSS STATUS,Z
	GOTO L0014
; 69: disp_count = 1
	MOVLW 0x01
	MOVWF 0x3D
	CLRF 0x3E
; 70: hour = hour + 1
	MOVF 0x37,W
	ADDLW 0x01
	MOVWF 0x37
; 71: If hour > 23 Then
	MOVF 0x37,W
	SUBLW 0x17
	BTFSC STATUS,C
	GOTO L0015
; 72: hour = 0
	CLRF 0x37
; 73: Endif
L0015:	MOVLW 0x1F
	ANDWF STATUS,F
; 74: Gosub write_clock
	CALL L0007
; 75: Endif
L0014:	MOVLW 0x1F
	ANDWF STATUS,F
; 76: Case 16
	GOTO L0016
L0013:	MOVLW 0x1F
	ANDWF STATUS,F
	MOVF 0x40,W
	SUBLW 0x10
	BTFSS STATUS,Z
	GOTO L0017
; 77: If key_delay = 0 Then
	MOVF 0x42,W
	SUBLW 0x00
	BTFSS STATUS,Z
	GOTO L0018
; 78: disp_count = 1
	MOVLW 0x01
	MOVWF 0x3D
	CLRF 0x3E
; 79: If hour > 0 Then
	MOVF 0x37,W
	SUBLW 0x00
	BTFSC STATUS,C
	GOTO L0019
; 80: hour = hour - 1
	MOVLW 0x01
	SUBWF 0x37,W
	MOVWF 0x37
; 81: Else
	GOTO L0020
L0019:	MOVLW 0x1F
	ANDWF STATUS,F
; 82: hour = 23
	MOVLW 0x17
	MOVWF 0x37
; 83: Endif
L0020:	MOVLW 0x1F
	ANDWF STATUS,F
; 84: Gosub write_clock
	CALL L0007
; 85: Endif
L0018:	MOVLW 0x1F
	ANDWF STATUS,F
; 86: Case 12
	GOTO L0021
L0017:	MOVLW 0x1F
	ANDWF STATUS,F
	MOVF 0x40,W
	SUBLW 0x0C
	BTFSS STATUS,Z
	GOTO L0022
; 87: If key_delay = 0 Then
	MOVF 0x42,W
	SUBLW 0x00
	BTFSS STATUS,Z
	GOTO L0023
; 88: disp_count = 1
	MOVLW 0x01
	MOVWF 0x3D
	CLRF 0x3E
; 89: minute = minute + 1
	MOVF 0x38,W
	ADDLW 0x01
	MOVWF 0x38
; 90: If minute > 59 Then
	MOVF 0x38,W
	SUBLW 0x3B
	BTFSC STATUS,C
	GOTO L0024
; 91: minute = 0
	CLRF 0x38
; 92: Endif
L0024:	MOVLW 0x1F
	ANDWF STATUS,F
; 93: Gosub write_clock
	CALL L0007
; 94: Endif
L0023:	MOVLW 0x1F
	ANDWF STATUS,F
; 95: Case 20
	GOTO L0025
L0022:	MOVLW 0x1F
	ANDWF STATUS,F
	MOVF 0x40,W
	SUBLW 0x14
	BTFSS STATUS,Z
	GOTO L0026
; 96: If key_delay = 0 Then
	MOVF 0x42,W
	SUBLW 0x00
	BTFSS STATUS,Z
	GOTO L0027
; 97: disp_count = 1
	MOVLW 0x01
	MOVWF 0x3D
	CLRF 0x3E
; 98: If minute > 0 Then
	MOVF 0x38,W
	SUBLW 0x00
	BTFSC STATUS,C
	GOTO L0028
; 99: minute = minute - 1
	MOVLW 0x01
	SUBWF 0x38,W
	MOVWF 0x38
; 100: Else
	GOTO L0029
L0028:	MOVLW 0x1F
	ANDWF STATUS,F
; 101: minute = 59
	MOVLW 0x3B
	MOVWF 0x38
; 102: Endif
L0029:	MOVLW 0x1F
	ANDWF STATUS,F
; 103: Gosub write_clock
	CALL L0007
; 104: Endif
L0027:	MOVLW 0x1F
	ANDWF STATUS,F
; 105: Case Else
	GOTO L0030
L0026:	MOVLW 0x1F
	ANDWF STATUS,F
; 106: 
; 107: EndSelect
L0030:	MOVLW 0x1F
	ANDWF STATUS,F
L0025:	MOVLW 0x1F
	ANDWF STATUS,F
L0021:	MOVLW 0x1F
	ANDWF STATUS,F
L0016:	MOVLW 0x1F
	ANDWF STATUS,F
; 108: key_delay = key_delay + 1 'this is ment to create a repeater for key
	MOVF 0x42,W
	ADDLW 0x01
	MOVWF 0x42
; 109: If key_delay = 60 Then
	MOVF 0x42,W
	SUBLW 0x3C
	BTFSS STATUS,Z
	GOTO L0031
; 110: key_delay = 0
	CLRF 0x42
; 111: Endif
L0031:	MOVLW 0x1F
	ANDWF STATUS,F
; 112: disp_count = disp_count + 1
	MOVF 0x3D,W
	ADDLW 0x01
	MOVWF 0x3D
	MOVF 0x3E,W
	BTFSC STATUS,C
	ADDLW 0x01
	ADDLW 0x00
	MOVWF 0x3E
; 113: If disp_count > 1200 Then 'temp and time are read every 6 secs.
	MOVF 0x3D,W
	MOVWF R0L
	MOVF 0x3E,W
	MOVWF R0H
	MOVLW 0x04
	MOVWF R1H
	MOVLW 0xB0
	CALL C003
	BTFSS STATUS,Z
	GOTO L0032
; 114: disp_count = 0
	CLRF 0x3D
	CLRF 0x3E
; 115: Gosub read_temperature
	CALL L0004
; 116: Gosub read_clock
	CALL L0006
; 117: Endif
L0032:	MOVLW 0x1F
	ANDWF STATUS,F
; 118: If disp_count < 600 Then
	MOVF 0x3D,W
	MOVWF R0L
	MOVF 0x3E,W
	MOVWF R0H
	MOVLW 0x02
	MOVWF R1H
	MOVLW 0x58
	CALL C004
	BTFSS STATUS,Z
	GOTO L0033
; 119: Gosub display_time
	CALL L0005
; 120: Else
	GOTO L0034
L0033:	MOVLW 0x1F
	ANDWF STATUS,F
; 121: Gosub display_temperature
	CALL L0003
; 122: Endif
L0034:	MOVLW 0x1F
	ANDWF STATUS,F
; 123: WaitMs 5
	MOVLW 0x05
	MOVWF R0L
	CLRF R0H
	CALL W001
; 124: Goto loop
	GOTO L0002
; 125: End
L0035:	GOTO L0035
; 126: display_temperature: 
L0003:
; 127: 
; 128: PORTC = %00011000
	MOVLW 0x18
	MOVWF 0x07
; 129: which_digit = which_digit + 1
	MOVF 0x39,W
	ADDLW 0x01
	MOVWF 0x39
; 130: If which_digit > 3 Then
	MOVF 0x39,W
	SUBLW 0x03
	BTFSC STATUS,C
	GOTO L0036
; 131: which_digit = 0
	CLRF 0x39
; 132: Endif 'D            0                1                    2                   3                     4                    5                   6                     7                 8                  9                                        C
L0036:	MOVLW 0x1F
	ANDWF STATUS,F
; 133: Select Case which_digit
; 134: Case 0
	MOVF 0x39,W
	SUBLW 0x00
	BTFSS STATUS,Z
	GOTO L0037
; 135: If temp0 > 0 Then
	MOVF 0x34,W
	SUBLW 0x00
	BTFSC STATUS,C
	GOTO L0038
; 136: PORTB = LookUp(%00111111, %00000110, %01011011, %01001111, %01100110, %01101101, %01111101, %00000111, %01111111, %01101111, %01101111, %01100011, %00111001), temp0
	MOVF 0x34,W
	SUBLW 0x0C
	BTFSS STATUS,C
	GOTO L0039
	CALL L0040
	MOVWF 0x06
	GOTO L0039
L0040:
	MOVLW 0x01
	MOVWF PCLATH
	MOVF 0x34,W
	ADDWF PCL,F
	RETLW 0x3F
	RETLW 0x06
	RETLW 0x5B
	RETLW 0x4F
	RETLW 0x66
	RETLW 0x6D
	RETLW 0x7D
	RETLW 0x07
	RETLW 0x7F
	RETLW 0x6F
	RETLW 0x6F
	RETLW 0x63
	RETLW 0x39
L0039:
; 137: Else
	GOTO L0041
L0038:	MOVLW 0x1F
	ANDWF STATUS,F
; 138: PORTB = 0
	CLRF 0x06
; 139: Endif
L0041:	MOVLW 0x1F
	ANDWF STATUS,F
; 140: PORTC = %00011001
	MOVLW 0x19
	MOVWF 0x07
; 141: Case 1
	GOTO L0042
L0037:	MOVLW 0x1F
	ANDWF STATUS,F
	MOVF 0x39,W
	SUBLW 0x01
	BTFSS STATUS,Z
	GOTO L0043
; 142: PORTB = LookUp(%00111111, %00000110, %01011011, %01001111, %01100110, %01101101, %01111101, %00000111, %01111111, %01101111, %01100011, %00111001), temp1
	MOVF 0x35,W
	SUBLW 0x0B
	BTFSS STATUS,C
	GOTO L0044
	CALL L0045
	MOVWF 0x06
	GOTO L0044
L0045:
	MOVLW 0x01
	MOVWF PCLATH
	MOVF 0x35,W
	ADDWF PCL,F
	RETLW 0x3F
	RETLW 0x06
	RETLW 0x5B
	RETLW 0x4F
	RETLW 0x66
	RETLW 0x6D
	RETLW 0x7D
	RETLW 0x07
	RETLW 0x7F
	RETLW 0x6F
	RETLW 0x63
	RETLW 0x39
L0044:
; 143: PORTC = %00011010
	MOVLW 0x1A
	MOVWF 0x07
; 144: Case 2
	GOTO L0046
L0043:	MOVLW 0x1F
	ANDWF STATUS,F
	MOVF 0x39,W
	SUBLW 0x02
	BTFSS STATUS,Z
	GOTO L0047
; 145: PORTB = %01100011 'THIS IS THE DEGREE SIGN
	MOVLW 0x63
	MOVWF 0x06
; 146: PORTC = %00011100
	MOVLW 0x1C
	MOVWF 0x07
; 147: Case Else
	GOTO L0048
L0047:	MOVLW 0x1F
	ANDWF STATUS,F
; 148: PORTB = %00111001 'Capital 'C'
	MOVLW 0x39
	MOVWF 0x06
; 149: PORTC = %00111000
	MOVLW 0x38
	MOVWF 0x07
; 150: EndSelect
L0048:	MOVLW 0x1F
	ANDWF STATUS,F
L0046:	MOVLW 0x1F
	ANDWF STATUS,F
L0042:	MOVLW 0x1F
	ANDWF STATUS,F
; 151: Return
	RETURN
; 152: 
; 153: read_temperature: 
L0004:
; 154: I2CStart
	CALL IC31
; 155: I2CSend 0x90
	MOVLW 0x90
	CALL IC01
; 156: I2CSend 0xee
	MOVLW 0xEE
	CALL IC01
; 157: I2CStop
	CALL IC41
; 158: WaitMs 10
	MOVLW 0x0A
	MOVWF R0L
	CLRF R0H
	CALL W001
; 159: I2CStart
	CALL IC31
; 160: I2CSend 0x90
	MOVLW 0x90
	CALL IC01
; 161: I2CSend 0xaa
	MOVLW 0xAA
	CALL IC01
; 162: I2CStop
	CALL IC41
; 163: I2CStart
	CALL IC31
; 164: I2CSend 0x91
	MOVLW 0x91
	CALL IC01
; 165: I2CRecA temperature
	CALL IC13
	MOVWF 0x36
; 166: I2CRecN temp0
	CALL IC11
	MOVWF 0x34
; 167: I2CStop
	CALL IC41
; 168: If temperature > 99 Then
	MOVF 0x36,W
	SUBLW 0x63
	BTFSC STATUS,C
	GOTO L0049
; 169: temperature = 99
	MOVLW 0x63
	MOVWF 0x36
; 170: Endif
L0049:	MOVLW 0x1F
	ANDWF STATUS,F
; 171: If temperature = 0 Then
	MOVF 0x36,W
	SUBLW 0x00
	BTFSS STATUS,Z
	GOTO L0050
; 172: temperature = 24
	MOVLW 0x18
	MOVWF 0x36
; 173: Endif
L0050:	MOVLW 0x1F
	ANDWF STATUS,F
; 174: temp0 = temperature / 10
	MOVF 0x36,W
	MOVWF R0L
	CLRF R0H
	MOVLW 0x0A
	MOVWF R1L
	CLRF R1H
	CALL D001
	MOVWF 0x34
; 175: temp1 = temperature Mod 10
	MOVF 0x36,W
	MOVWF R0L
	CLRF R0H
	MOVLW 0x0A
	MOVWF R1L
	CLRF R1H
	CALL D001
	MOVF R2L,W
	MOVWF 0x35
; 176: Return
	RETURN
; 177: 
; 178: 
; 179: display_time: 
L0005:
; 180: dis0 = hour / 10
	MOVF 0x37,W
	MOVWF R0L
	CLRF R0H
	MOVLW 0x0A
	MOVWF R1L
	CLRF R1H
	CALL D001
	MOVWF 0x30
; 181: dis1 = hour Mod 10
	MOVF 0x37,W
	MOVWF R0L
	CLRF R0H
	MOVLW 0x0A
	MOVWF R1L
	CLRF R1H
	CALL D001
	MOVF R2L,W
	MOVWF 0x31
; 182: dis2 = minute / 10
	MOVF 0x38,W
	MOVWF R0L
	CLRF R0H
	MOVLW 0x0A
	MOVWF R1L
	CLRF R1H
	CALL D001
	MOVWF 0x32
; 183: dis3 = minute Mod 10
	MOVF 0x38,W
	MOVWF R0L
	CLRF R0H
	MOVLW 0x0A
	MOVWF R1L
	CLRF R1H
	CALL D001
	MOVF R2L,W
	MOVWF 0x33
; 184: PORTC = %00011000
	MOVLW 0x18
	MOVWF 0x07
; 185: which_digit = which_digit + 1
	MOVF 0x39,W
	ADDLW 0x01
	MOVWF 0x39
; 186: If which_digit > 3 Then
	MOVF 0x39,W
	SUBLW 0x03
	BTFSC STATUS,C
	GOTO L0051
; 187: which_digit = 0
	CLRF 0x39
; 188: Endif
L0051:	MOVLW 0x1F
	ANDWF STATUS,F
; 189: Select Case which_digit
; 190: Case 0
	MOVF 0x39,W
	SUBLW 0x00
	BTFSS STATUS,Z
	GOTO L0052
; 191: If dis0 > 0 Then
	MOVF 0x30,W
	SUBLW 0x00
	BTFSC STATUS,C
	GOTO L0053
; 192: PORTB = LookUp(%00111111, %00000110, %01011011, %01001111, %01100110, %01101101, %01111101, %00000111, %01111111, %01101111), dis0
	MOVF 0x30,W
	SUBLW 0x09
	BTFSS STATUS,C
	GOTO L0054
	CALL L0055
	MOVWF 0x06
	GOTO L0054
L0055:
	MOVLW 0x02
	MOVWF PCLATH
	MOVF 0x30,W
	ADDWF PCL,F
	RETLW 0x3F
	RETLW 0x06
	RETLW 0x5B
	RETLW 0x4F
	RETLW 0x66
	RETLW 0x6D
	RETLW 0x7D
	RETLW 0x07
	RETLW 0x7F
	RETLW 0x6F
L0054:
; 193: Else
	GOTO L0056
L0053:	MOVLW 0x1F
	ANDWF STATUS,F
; 194: PORTB = 0
	CLRF 0x06
; 195: Endif
L0056:	MOVLW 0x1F
	ANDWF STATUS,F
; 196: PORTC = %00011001
	MOVLW 0x19
	MOVWF 0x07
; 197: Case 1
	GOTO L0057
L0052:	MOVLW 0x1F
	ANDWF STATUS,F
	MOVF 0x39,W
	SUBLW 0x01
	BTFSS STATUS,Z
	GOTO L0058
; 198: PORTB = LookUp(%10111111, %10000110, %11011011, %11001111, %11100110, %11101101, %11111101, %10000111, %11111111, %11101111), dis1
	MOVF 0x31,W
	SUBLW 0x09
	BTFSS STATUS,C
	GOTO L0059
	CALL L0060
	MOVWF 0x06
	GOTO L0059
L0060:
	MOVLW 0x02
	MOVWF PCLATH
	MOVF 0x31,W
	ADDWF PCL,F
	RETLW 0xBF
	RETLW 0x86
	RETLW 0xDB
	RETLW 0xCF
	RETLW 0xE6
	RETLW 0xED
	RETLW 0xFD
	RETLW 0x87
	RETLW 0xFF
	RETLW 0xEF
L0059:
; 199: PORTC = %00011010
	MOVLW 0x1A
	MOVWF 0x07
; 200: Case 2
	GOTO L0061
L0058:	MOVLW 0x1F
	ANDWF STATUS,F
	MOVF 0x39,W
	SUBLW 0x02
	BTFSS STATUS,Z
	GOTO L0062
; 201: PORTB = LookUp(%00111111, %00000110, %01011011, %01001111, %01100110, %01101101, %01111101, %00000111, %01111111, %01101111), dis2
	MOVF 0x32,W
	SUBLW 0x09
	BTFSS STATUS,C
	GOTO L0063
	CALL L0064
	MOVWF 0x06
	GOTO L0063
L0064:
	MOVLW 0x02
	MOVWF PCLATH
	MOVF 0x32,W
	ADDWF PCL,F
	RETLW 0x3F
	RETLW 0x06
	RETLW 0x5B
	RETLW 0x4F
	RETLW 0x66
	RETLW 0x6D
	RETLW 0x7D
	RETLW 0x07
	RETLW 0x7F
	RETLW 0x6F
L0063:
; 202: PORTC = %00011100
	MOVLW 0x1C
	MOVWF 0x07
; 203: Case Else
	GOTO L0065
L0062:	MOVLW 0x1F
	ANDWF STATUS,F
; 204: PORTB = LookUp(%00111111, %00000110, %01011011, %01001111, %01100110, %01101101, %01111101, %00000111, %01111111, %01101111), dis3
	MOVF 0x33,W
	SUBLW 0x09
	BTFSS STATUS,C
	GOTO L0066
	CALL L0067
	MOVWF 0x06
	GOTO L0066
L0067:
	MOVLW 0x02
	MOVWF PCLATH
	MOVF 0x33,W
	ADDWF PCL,F
	RETLW 0x3F
	RETLW 0x06
	RETLW 0x5B
	RETLW 0x4F
	RETLW 0x66
	RETLW 0x6D
	RETLW 0x7D
	RETLW 0x07
	RETLW 0x7F
	RETLW 0x6F
L0066:
; 205: PORTC = %00111000
	MOVLW 0x38
	MOVWF 0x07
; 206: EndSelect
L0065:	MOVLW 0x1F
	ANDWF STATUS,F
L0061:	MOVLW 0x1F
	ANDWF STATUS,F
L0057:	MOVLW 0x1F
	ANDWF STATUS,F
; 207: Return
	RETURN
; 208: 
; 209: read_clock: 
L0006:
; 210: addr = 3
	MOVLW 0x03
	MOVWF 0x3C
; 211: I2CRead sda, scl, 0xa0, addr, minute
	MOVLW 0x07
	MOVWF SDA_PORT
	MOVLW 0x10
	MOVWF SDA_BIT
	BSF STATUS,RP0
	BCF TRISC,4
	BCF STATUS,RP0
	MOVLW 0x07
	MOVWF SCL_PORT
	MOVLW 0x08
	MOVWF SCL_BIT
	BSF STATUS,RP0
	BCF TRISC,3
	BCF STATUS,RP0
	CALL IC41
	CALL IC41
	CALL IC31
	MOVLW 0xA0
	CALL IC01
	MOVF 0x3C,W
	CALL IC01
	CALL IC41
	CALL IC31
	MOVLW 0xA1
	CALL IC01
	CALL IC11
	MOVWF 0x38
	CALL IC41
; 212: var1 = minute
	MOVF 0x38,W
	MOVWF 0x40
; 213: var1 = var1 And 15
	MOVF 0x40,W
	MOVWF R0L
	MOVLW 0x0F
	ANDWF R0L,W
	MOVWF 0x40
; 214: var2 = minute
	MOVF 0x38,W
	MOVWF 0x41
; 215: var2 = var2 And 112
	MOVF 0x41,W
	MOVWF R0L
	MOVLW 0x70
	ANDWF R0L,W
	MOVWF 0x41
; 216: var2 = var2 / 16
	MOVF 0x41,W
	MOVWF R0L
	CLRF R0H
	MOVLW 0x10
	MOVWF R1L
	CLRF R1H
	CALL D001
	MOVWF 0x41
; 217: var2 = var2 * 10
	MOVF 0x41,W
	MOVWF R3L
	CLRF R3H
	MOVLW 0x0A
	MOVWF R1L
	CLRF R1H
	CALL M001
	MOVWF 0x41
; 218: minute = var1 + var2
	MOVF 0x40,W
	ADDWF 0x41,W
	MOVWF 0x38
; 219: addr = 4
	MOVLW 0x04
	MOVWF 0x3C
; 220: I2CRead sda, scl, 0xa0, addr, hour
	MOVLW 0x07
	MOVWF SDA_PORT
	MOVLW 0x10
	MOVWF SDA_BIT
	BSF STATUS,RP0
	BCF TRISC,4
	BCF STATUS,RP0
	MOVLW 0x07
	MOVWF SCL_PORT
	MOVLW 0x08
	MOVWF SCL_BIT
	BSF STATUS,RP0
	BCF TRISC,3
	BCF STATUS,RP0
	CALL IC41
	CALL IC41
	CALL IC31
	MOVLW 0xA0
	CALL IC01
	MOVF 0x3C,W
	CALL IC01
	CALL IC41
	CALL IC31
	MOVLW 0xA1
	CALL IC01
	CALL IC11
	MOVWF 0x37
	CALL IC41
; 221: var1 = hour
	MOVF 0x37,W
	MOVWF 0x40
; 222: var1 = var1 And 15
	MOVF 0x40,W
	MOVWF R0L
	MOVLW 0x0F
	ANDWF R0L,W
	MOVWF 0x40
; 223: var2 = hour
	MOVF 0x37,W
	MOVWF 0x41
; 224: var2 = var2 And 48
	MOVF 0x41,W
	MOVWF R0L
	MOVLW 0x30
	ANDWF R0L,W
	MOVWF 0x41
; 225: var2 = var2 / 16
	MOVF 0x41,W
	MOVWF R0L
	CLRF R0H
	MOVLW 0x10
	MOVWF R1L
	CLRF R1H
	CALL D001
	MOVWF 0x41
; 226: var2 = var2 * 10
	MOVF 0x41,W
	MOVWF R3L
	CLRF R3H
	MOVLW 0x0A
	MOVWF R1L
	CLRF R1H
	CALL M001
	MOVWF 0x41
; 227: hour = var1 + var2
	MOVF 0x40,W
	ADDWF 0x41,W
	MOVWF 0x37
; 228: 
; 229: Return
	RETURN
; 230: 
; 231: write_clock: 
L0007:
; 232: 
; 233: var1 = hour
	MOVF 0x37,W
	MOVWF 0x40
; 234: var1 = var1 Mod 10
	MOVF 0x40,W
	MOVWF R0L
	CLRF R0H
	MOVLW 0x0A
	MOVWF R1L
	CLRF R1H
	CALL D001
	MOVF R2L,W
	MOVWF 0x40
; 235: var2 = hour
	MOVF 0x37,W
	MOVWF 0x41
; 236: var2 = var2 / 10
	MOVF 0x41,W
	MOVWF R0L
	CLRF R0H
	MOVLW 0x0A
	MOVWF R1L
	CLRF R1H
	CALL D001
	MOVWF 0x41
; 237: var2 = var2 * 16
	MOVF 0x41,W
	MOVWF R3L
	CLRF R3H
	MOVLW 0x10
	MOVWF R1L
	CLRF R1H
	CALL M001
	MOVWF 0x41
; 238: value = var1 + var2
	MOVF 0x40,W
	ADDWF 0x41,W
	MOVWF 0x3B
; 239: addr = 4
	MOVLW 0x04
	MOVWF 0x3C
; 240: I2CWrite sda, scl, 0xa0, addr, value
	MOVLW 0x07
	MOVWF SDA_PORT
	MOVLW 0x10
	MOVWF SDA_BIT
	BSF STATUS,RP0
	BCF TRISC,4
	BCF STATUS,RP0
	MOVLW 0x07
	MOVWF SCL_PORT
	MOVLW 0x08
	MOVWF SCL_BIT
	BSF STATUS,RP0
	BCF TRISC,3
	BCF STATUS,RP0
	CALL IC41
	CALL IC41
	CALL IC31
	MOVLW 0xA0
	CALL IC01
	MOVF 0x3C,W
	CALL IC01
	MOVF 0x3B,W
	CALL IC01
	CALL IC41
; 241: var1 = minute
	MOVF 0x38,W
	MOVWF 0x40
; 242: var1 = var1 Mod 10
	MOVF 0x40,W
	MOVWF R0L
	CLRF R0H
	MOVLW 0x0A
	MOVWF R1L
	CLRF R1H
	CALL D001
	MOVF R2L,W
	MOVWF 0x40
; 243: var2 = minute
	MOVF 0x38,W
	MOVWF 0x41
; 244: var2 = var2 / 10
	MOVF 0x41,W
	MOVWF R0L
	CLRF R0H
	MOVLW 0x0A
	MOVWF R1L
	CLRF R1H
	CALL D001
	MOVWF 0x41
; 245: var2 = var2 * 16
	MOVF 0x41,W
	MOVWF R3L
	CLRF R3H
	MOVLW 0x10
	MOVWF R1L
	CLRF R1H
	CALL M001
	MOVWF 0x41
; 246: value = var1 + var2
	MOVF 0x40,W
	ADDWF 0x41,W
	MOVWF 0x3B
; 247: addr = 3
	MOVLW 0x03
	MOVWF 0x3C
; 248: I2CWrite sda, scl, 0xa0, addr, value
	MOVLW 0x07
	MOVWF SDA_PORT
	MOVLW 0x10
	MOVWF SDA_BIT
	BSF STATUS,RP0
	BCF TRISC,4
	BCF STATUS,RP0
	MOVLW 0x07
	MOVWF SCL_PORT
	MOVLW 0x08
	MOVWF SCL_BIT
	BSF STATUS,RP0
	BCF TRISC,3
	BCF STATUS,RP0
	CALL IC41
	CALL IC41
	CALL IC31
	MOVLW 0xA0
	CALL IC01
	MOVF 0x3C,W
	CALL IC01
	MOVF 0x3B,W
	CALL IC01
	CALL IC41
; 249: Return
	RETURN
; 250: 
; 251: init_temperature: 
L0008:
; 252:  'addr = 0x90
; 253:  'I2CStart
; 254: 
; 255:  'I2CWrite sda, scl, addr, 0xac, 2
; 256: Return
	RETURN
; 257: 
; 258: init_clock: 
L0009:
; 259: addr = 0
	CLRF 0x3C
; 260: I2CWrite sda, scl, 0xa0, addr, %00001000
	MOVLW 0x07
	MOVWF SDA_PORT
	MOVLW 0x10
	MOVWF SDA_BIT
	BSF STATUS,RP0
	BCF TRISC,4
	BCF STATUS,RP0
	MOVLW 0x07
	MOVWF SCL_PORT
	MOVLW 0x08
	MOVWF SCL_BIT
	BSF STATUS,RP0
	BCF TRISC,3
	BCF STATUS,RP0
	CALL IC41
	CALL IC41
	CALL IC31
	MOVLW 0xA0
	CALL IC01
	MOVF 0x3C,W
	CALL IC01
	MOVLW 0x08
	CALL IC01
	CALL IC41
; 261: 
; 262: 
; 263: Return
	RETURN
; 264: 
; End of program
L0068:	GOTO L0068
; Multiplication Routine
M001:	MOVLW 0x10
	MOVWF R4L
	CLRF R0H
	CLRF R0L
M002:	RRF R3H,F
	RRF R3L,F
	BTFSS STATUS,C
	GOTO M003
	MOVF R1L,W
	ADDWF R0L,F
	MOVF R1H,W
	BTFSC STATUS,C
	INCFSZ R1H,W
	ADDWF R0H,F
M003:	RRF R0H,F
	RRF R0L,F
	RRF R2H,F
	RRF R2L,F
	DECFSZ R4L,F
	GOTO M002
	MOVF R2L,W
	RETURN
; Division Routine
D001:	MOVLW 0x10
	MOVWF R3L
	CLRF R2H
	CLRF R2L
D002:	RLF R0H,W
	RLF R2L,F
	RLF R2H,F
	MOVF R1L,W
	SUBWF R2L,F
	MOVF R1H,W
	BTFSS STATUS,C
	INCFSZ R1H,W
	SUBWF R2H,F
	BTFSC STATUS,C
	GOTO D003
	MOVF R1L,W
	ADDWF R2L,F
	MOVF R1H,W
	BTFSC STATUS,C
	INCFSZ R1H,W
	ADDWF R2H,F
	BCF STATUS,C
D003:	RLF R0L,F
	RLF R0H,F
	DECFSZ R3L,F
	GOTO D002
	MOVF R0L,W
	RETURN
; Comparison Routine
C001:	MOVWF R1L
	MOVLW 0x05
	GOTO C007
C002:	MOVWF R1L
	MOVLW 0x02
	GOTO C007
C003:	MOVWF R1L
	MOVLW 0x06
	GOTO C007
C004:	MOVWF R1L
	MOVLW 0x03
	GOTO C007
C005:	MOVWF R1L
	MOVLW 0x04
	GOTO C007
C006:	MOVWF R1L
	MOVLW 0x01
	GOTO C007
C007:	MOVWF R4L
	MOVF R1H,W
	SUBWF R0H,W
	BTFSS STATUS,Z
	GOTO C008
	MOVF R1L,W
	SUBWF R0L,W
C008:	MOVLW 0x04
	BTFSC STATUS,C
	MOVLW 0x01
	BTFSC STATUS,Z
	MOVLW 0x02
	ANDWF R4L,W
	BTFSS STATUS,Z
	MOVLW 0xFF
	RETURN
; Waitms Routine
W001:	MOVF R0L,F
	BTFSC STATUS,Z
	GOTO W002
	CALL W003
	DECF R0L,F
	NOP
	NOP
	NOP
	NOP
	NOP
	GOTO W001
W002:	MOVF R0H,F
	BTFSC STATUS,Z
	RETURN
	CALL W003
	DECF R0H,F
	DECF R0L,F
	GOTO W001
W003:	MOVLW 0x0C
	MOVWF R2H
W004:	DECFSZ R2H,F
	GOTO W004
	NOP
	NOP
	MOVLW 0x62
	MOVWF R1L
W005:	DECFSZ R1L,F
	GOTO W006
	CALL W007
	CALL W007
	NOP
	NOP
	RETURN
W006:	CALL W007
	GOTO W005
W007:	MOVLW 0x0D
	MOVWF R2L
W008:	DECFSZ R2L,F
	GOTO W008
	NOP
	RETURN
; I2CWrite Routine
IC01:	MOVWF R0L
	MOVLW 0x08
	MOVWF R0H
IC02:	RLF R0L,F
	BTFSC STATUS,C
	CALL IC20
	BTFSS STATUS,C
	CALL IC21
	CALL IC22
	CALL IC23
	DECFSZ R0H,F
	GOTO IC02
	CALL IC24
	CALL IC03
	CALL IC25
	CALL IC21
	RETURN
IC03:	CALL IC22
	MOVF SDA_PORT,W
	MOVWF FSR
	MOVF SDA_BIT,W
	ANDWF INDF,W
	ADDLW 0xFF
	CALL IC23
	RETURN
IC31:	CALL IC21
	CALL IC23
	GOTO IC29
IC41:	CALL IC22
	CALL IC20
	GOTO IC29
IC20:	MOVF SDA_PORT,W
	MOVWF FSR
	MOVF SDA_BIT,W
	IORWF INDF,F
	GOTO IC28
IC21:	MOVF SDA_PORT,W
	MOVWF FSR
	COMF SDA_BIT,W
	ANDWF INDF,F
	GOTO IC28
IC22:	MOVF SCL_PORT,W
	MOVWF FSR
	MOVF SCL_BIT,W
	IORWF INDF,F
	GOTO IC28
IC23:	MOVF SCL_PORT,W
	MOVWF FSR
	COMF SCL_BIT,W
	ANDWF INDF,F
	GOTO IC28
IC28:	BSF FSR,7
	COMF INDF,W
	BCF FSR,7
	ANDWF INDF,F
IC29:	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	RETURN
IC24:	MOVF SDA_PORT,W
	MOVWF FSR
	BSF FSR,7
	MOVF SDA_BIT,W
	IORWF INDF,F
	RETURN
IC25:	MOVF SDA_PORT,W
	MOVWF FSR
	BSF FSR,7
	COMF SDA_BIT,W
	ANDWF INDF,F
	RETURN
; I2CRead Routine
IC11:	CALL IC24
	MOVLW 0x08
	MOVWF R0H
IC12:	CALL IC03
	RLF R0L,F
	DECFSZ R0H,F
	GOTO IC12
	CALL IC25
	CALL IC20
	CALL IC22
	CALL IC23
	CALL IC21
	MOVF R0L,W
	RETURN
IC13:	CALL IC24
	MOVLW 0x08
	MOVWF R0H
IC14:	CALL IC03
	RLF R0L,F
	DECFSZ R0H,F
	GOTO IC14
	CALL IC25
	CALL IC21
	CALL IC22
	CALL IC23
	MOVF R0L,W
	RETURN
; Configuration word settings
	ORG 0x2007
	DW 0x3F72
; End of listing
	END
