; Compiled with: PIC Simulator IDE v6.90
; Microcontroller model: PIC16F628A
; Clock frequency: 20.0 MHz
;
;       The address of 'fn1' (bit) (global) is 0x5,4
;       The address of 'fn2' (bit) (global) is 0x6,0
;       The address of 'fn3' (bit) (global) is 0x6,1
;       The address of 'fn4' (bit) (global) is 0x6,2
;       The address of 'irs1' (bit) (global) is 0x5,0
;       The address of 'irs2' (bit) (global) is 0x5,1
;       The address of 'irs3' (bit) (global) is 0x5,2
;       The address of 'irs4' (bit) (global) is 0x5,3
;       The address of 'ju1' (bit) (global) is 0x6,4
;       The address of 'ju2' (bit) (global) is 0x6,5
;       The address of 'ju3' (bit) (global) is 0x6,6
;       The address of 'ju4' (bit) (global) is 0x6,7
; Begin
	R0L EQU 0x20
	R0H EQU 0x21
	R1L EQU 0x22
	R1H EQU 0x23
	R2L EQU 0x24
	R2H EQU 0x25
	R3L EQU 0x26
	R3H EQU 0x27
	R4L EQU 0x28
	R4H EQU 0x29
	R5L EQU 0x2A
	R5H EQU 0x2B
	ORG 0x0000
	BCF PCLATH,3
	BCF PCLATH,4
	GOTO L0002
	ORG 0x0004
	RETFIE
; Begin of program
L0002:
; 1: Define CONF_WORD = 0x3f42
; 2: 
; 3: 'Program MGV133 Quadruple IR gate
; 4: 'In this program there is only 10mSec delay in on/off , so will be able to count 50Hz pulses
; 5: Symbol fn1 = RA4
; 6: Symbol fn2 = RB0
; 7: Symbol fn3 = RB1
; 8: Symbol fn4 = RB2
; 9: Symbol irs1 = RA0
; 10: Symbol irs2 = RA1
; 11: Symbol irs3 = RA2
; 12: Symbol irs4 = RA3
; 13: Symbol ju1 = RB4
; 14: Symbol ju2 = RB5
; 15: Symbol ju3 = RB6
; 16: Symbol ju4 = RB7
; 17: AllDigital
	MOVLW 0x07
	MOVWF 0x1F
; 18: CMCON = 7
	MOVLW 0x07
	MOVWF 0x1F
; 19: TRISA = %001111
	MOVLW 0x0F
	BSF STATUS,RP0
	MOVWF 0x05
	BCF STATUS,RP0
; 20: TRISB = %11111000
	MOVLW 0xF8
	BSF STATUS,RP0
	MOVWF 0x06
	BCF STATUS,RP0
; 21: PWMon 1, 9 'set to 36 KHz output at RB3
	MOVLW 0x3F
	BSF STATUS,RP0
	MOVWF PR2
	BCF TRISB,3
	BCF STATUS,RP0
	CLRF CCPR1L
	BCF CCP1CON,CCP1X
	BCF CCP1CON,CCP1Y
	BCF T2CON,T2CKPS0
	BCF T2CON,T2CKPS1
	BSF T2CON,TMR2ON
	MOVLW 0x0C
	IORWF CCP1CON,F
; 22: PWMduty 1, 127
	BSF CCP1CON,CCP1Y
	BSF CCP1CON,CCP1X
	MOVLW 0x20
	MOVWF CCPR1L
; 23: loop:
L0001:
; 24: 	If ju1 = 1 Then
	BTFSS 0x06,4
	GOTO L0003
; 25: 		fn1 = irs1
	BTFSC 0x05,0
	BSF 0x05,4
	BTFSS 0x05,0
	BCF 0x05,4
; 26: 	Else
	GOTO L0004
L0003:
; 27: 		fn1 = Not irs1
	BTFSS 0x05,0
	BSF 0x05,4
	BTFSC 0x05,0
	BCF 0x05,4
; 28: 	Endif
L0004:
; 29: 	If ju2 = 1 Then
	BTFSS 0x06,5
	GOTO L0005
; 30: 		fn2 = irs2
	BTFSC 0x05,1
	BSF 0x06,0
	BTFSS 0x05,1
	BCF 0x06,0
; 31: 	Else
	GOTO L0006
L0005:
; 32: 		fn2 = Not irs2
	BTFSS 0x05,1
	BSF 0x06,0
	BTFSC 0x05,1
	BCF 0x06,0
; 33: 	Endif
L0006:
; 34: 	If ju3 = 1 Then
	BTFSS 0x06,6
	GOTO L0007
; 35: 		fn3 = irs3
	BTFSC 0x05,2
	BSF 0x06,1
	BTFSS 0x05,2
	BCF 0x06,1
; 36: 	Else
	GOTO L0008
L0007:
; 37: 		fn3 = Not irs3
	BTFSS 0x05,2
	BSF 0x06,1
	BTFSC 0x05,2
	BCF 0x06,1
; 38: 	Endif
L0008:
; 39: 	If ju4 = 1 Then
	BTFSS 0x06,7
	GOTO L0009
; 40: 		fn4 = irs4
	BTFSC 0x05,3
	BSF 0x06,2
	BTFSS 0x05,3
	BCF 0x06,2
; 41: 	Else
	GOTO L0010
L0009:
; 42: 		fn4 = Not irs4
	BTFSS 0x05,3
	BSF 0x06,2
	BTFSC 0x05,3
	BCF 0x06,2
; 43: 	Endif
L0010:
; 44: 	WaitMs 10
	MOVLW 0x0A
	MOVWF R0L
	CLRF R0H
	CALL W001
; 45: Goto loop
	GOTO L0001
; 46: End
L0011:	GOTO L0011
; End of program
L0012:	GOTO L0012
; Waitms Routine
W001:	MOVF R0L,F
	BTFSC STATUS,Z
	GOTO W002
	CALL W003
	DECF R0L,F
	NOP
	NOP
	NOP
	NOP
	NOP
	GOTO W001
W002:	MOVF R0H,F
	BTFSC STATUS,Z
	RETURN
	CALL W003
	DECF R0H,F
	DECF R0L,F
	GOTO W001
W003:	MOVLW 0x0C
	MOVWF R2H
W004:
	DECFSZ R2H,F
	GOTO W004
	NOP
	NOP
	MOVLW 0x62
	MOVWF R1L
W005:
	DECFSZ R1L,F
	GOTO W006
	CALL W007
	CALL W007
	NOP
	NOP
	RETURN
W006:
	CALL W007
	GOTO W005
W007:	MOVLW 0x0D
	MOVWF R2L
W008:
	DECFSZ R2L,F
	GOTO W008
	NOP
	RETURN
; Configuration word settings
	ORG 0x2007
	DW 0x3F42
; End of listing
	END
