; Compiled with: PIC Simulator IDE v6.86
; Microcontroller model: PIC16F628A
; Clock frequency: 4.0 MHz
;
;       The address of 'servo' (array 3) (byte) (global) is 0x2C
	servo EQU 0x2C
;       The value of 'barrier_pos_up' (global) is 200
;       The value of 'barrier_pos_down' (global) is 100
;       The address of 'dummy' (byte) (global) is 0x2F
	dummy EQU 0x2F
;       The address of 'counter' (byte) (global) is 0x30
	counter EQU 0x30
;       The address of 'action' (byte) (global) is 0x31
	action EQU 0x31
;       The address of 'claim' (byte) (global) is 0x32
	claim EQU 0x32
;       The value of 'barrier_down' (global) is 1
;       The value of 'barrier_up' (global) is 0
;       The address of 'red1' (bit) (global) is 0x5,2
;       The address of 'red2' (bit) (global) is 0x5,3
;       The address of 'yel1' (bit) (global) is 0x5,0
;       The address of 'yel2' (bit) (global) is 0x5,1
; Procedure declaration: Proc check_inputs()
; Begin
	R0L EQU 0x20
	R0H EQU 0x21
	R1L EQU 0x22
	R1H EQU 0x23
	R2L EQU 0x24
	R2H EQU 0x25
	R3L EQU 0x26
	R3H EQU 0x27
	R4L EQU 0x28
	R4H EQU 0x29
	R5L EQU 0x2A
	R5H EQU 0x2B
	ORG 0x0000
	BCF PCLATH,3
	BCF PCLATH,4
	GOTO L0002
	ORG 0x0004
	RETFIE
; Begin of program
L0002:
; 1: 'program for controlling 4 servos on railroad crossing (german type)
; 2: 'Yellow lighst are connected to pin 7 and 8 of J6
; 3: 'red lighst are connected  to pin 9 and 10 of J6
; 4: 'servos  for right barriers (traffic direction!) are to be connected to J1 and J2
; 5: 'servos  for left barriers (traffic direction!) are to be connected to J3 and J4
; 6: 'in case MGV136 is used without MGV50:
; 7: 'a supply of 5 volt needs to be connected to Pin1(plus 5V) and pin2 (minus 5Volt) of J6
; 8: 'leds are To be connected between pin1 (anode) and pin 7,8,9 or 10 (kathode) of J6.
; 9: Define CONF_WORD = 0x3f50
; 10: AllDigital
	MOVLW 0x07
	MOVWF 0x1F
; 11: TRISB = %00000001
	BSF STATUS,RP0
	MOVLW 0x01
	MOVWF 0x06
; 12: TRISA = %11110000
	MOVLW 0xF0
	MOVWF 0x05
	BCF STATUS,RP0
; 13: Dim servo(3) As Byte
; 14: Const barrier_pos_up = 200
; 15: Const barrier_pos_down = 100
; 16: Dim dummy As Byte
; 17: Dim counter As Byte
; 18: Dim action As Byte
; 19: Dim claim As Byte
; 20: Const barrier_down = 1
; 21: Const barrier_up = 0
; 22: Symbol red1 = RA2
; 23: Symbol red2 = RA3
; 24: Symbol yel1 = RA0
; 25: Symbol yel2 = RA1
; 26: 
; 27: 
; 28: For counter = 1 To 2
	MOVLW 0x01
	MOVWF 0x30
L0003:
	MOVF 0x30,W
	SUBLW 0x02
	BTFSS STATUS,C
	GOTO L0004
; 29: 	Read counter, servo(counter)
	MOVF 0x30,W
	BSF STATUS,RP0
	MOVWF EEADR
	BSF EECON1,RD
	NOP
	MOVF EEDATA,W
	BCF STATUS,RP0
	MOVWF R5L
	MOVF 0x30,W
	ADDLW 0x2C
	MOVWF FSR
	MOVF R5L,W
	MOVWF INDF
; 30: 	If servo(counter) > 200 Then
	MOVF 0x30,W
	ADDLW 0x2C
	MOVWF FSR
	MOVF INDF,W
	SUBLW 0xC8
	BTFSC STATUS,C
	GOTO L0005
; 31: 		servo(counter) = 200
	MOVF 0x30,W
	ADDLW 0x2C
	MOVWF FSR
	MOVLW 0xC8
	MOVWF INDF
; 32: 	Endif
L0005:
; 33: 	If servo(counter) = barrier_pos_up Then
	MOVF 0x30,W
	ADDLW 0x2C
	MOVWF FSR
	MOVF INDF,W
	SUBLW 0xC8
	BTFSS STATUS,Z
	GOTO L0006
; 34: 		action(counter) = barrier_up
	MOVF 0x30,W
	ADDLW 0x31
	MOVWF FSR
	MOVLW 0x00
	MOVWF INDF
; 35: 	Else
	GOTO L0007
L0006:
; 36: 		action(counter) = barrier_down
	MOVF 0x30,W
	ADDLW 0x31
	MOVWF FSR
	MOVLW 0x01
	MOVWF INDF
; 37: 	Endif
L0007:
; 38: 
; 39: Next counter
	MOVLW 0x01
	ADDWF 0x30,F
	BTFSS STATUS,C
	GOTO L0003
L0004:
; 40: dummy = 1
	MOVLW 0x01
	MOVWF 0x2F
; 41: claim = 0
	CLRF 0x32
; 42: WaitMs 3000 'long wait to give MGV50 time for correct startup
	MOVLW 0xB8
	MOVWF R0L
	MOVLW 0x0B
	MOVWF R0H
	CALL W001
; 43: 
; 44: '--------------------------- PROGRAM Mainloop ---------------------------
; 45: While dummy = 1 'endless loop
L0008:
	MOVF 0x2F,W
	SUBLW 0x01
	BTFSS STATUS,Z
	GOTO L0009
; 46: 	If claim > 0 Then 'barrier 1 going down
	MOVF 0x32,W
	SUBLW 0x00
	BTFSC STATUS,C
	GOTO L0010
; 47: 		If action <> barrier_down Then
	MOVF 0x31,W
	SUBLW 0x01
	BTFSC STATUS,Z
	GOTO L0011
; 48: 			servo(1) = barrier_pos_up
	MOVLW 0xC8
	MOVWF 0x2D
; 49: 			servo(2) = barrier_pos_up
	MOVLW 0xC8
	MOVWF 0x2E
; 50: 			yel1 = 1 'first the orange led #1 for 2 seconds
	BSF 0x05,0
; 51: 			yel2 = 1 'first the orange led #2 for 2 seconds
	BSF 0x05,1
; 52: 			WaitMs 2000
	MOVLW 0xD0
	MOVWF R0L
	MOVLW 0x07
	MOVWF R0H
	CALL W001
; 53: 			red1 = 1 'now the red light #1 is on
	BSF 0x05,2
; 54: 			red2 = 1 'now the red light #2 is on
	BSF 0x05,3
; 55: 			yel1 = 0 'orange light off
	BCF 0x05,0
; 56: 			yel2 = 0 'orange light off
	BCF 0x05,1
; 57: 			WaitMs 5000 'wait 5 seconds
	MOVLW 0x88
	MOVWF R0L
	MOVLW 0x13
	MOVWF R0H
	CALL W001
; 58: 			While servo(1) > barrier_pos_down 'first the right barriers
L0012:
	MOVF 0x2D,W
	SUBLW 0x64
	BTFSC STATUS,C
	GOTO L0013
; 59: 				ServoOut RB4, servo(1) 'so needs to be run twice to get right speed.
	MOVF 0x2D,W
	MOVWF R4H
	MOVF R4H,F
	BTFSC STATUS,Z
	GOTO L0015
	BSF PORTB,4
L0014:
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	DECF R4H,F
	BTFSS STATUS,Z
	GOTO L0014
	BCF PORTB,4
L0015:
; 60: 				ServoOut RB5, servo(1)
	MOVF 0x2D,W
	MOVWF R4H
	MOVF R4H,F
	BTFSC STATUS,Z
	GOTO L0017
	BSF PORTB,5
L0016:
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	DECF R4H,F
	BTFSS STATUS,Z
	GOTO L0016
	BCF PORTB,5
L0017:
; 61: 				WaitMs 9
	MOVLW 0x09
	MOVWF R0L
	CLRF R0H
	CALL W001
; 62: 				Call check_inputs()
	CALL L0001
; 63: 				ServoOut RB4, servo(1) 'so needs to be run twice to get right speed.
	MOVF 0x2D,W
	MOVWF R4H
	MOVF R4H,F
	BTFSC STATUS,Z
	GOTO L0019
	BSF PORTB,4
L0018:
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	DECF R4H,F
	BTFSS STATUS,Z
	GOTO L0018
	BCF PORTB,4
L0019:
; 64: 				ServoOut RB5, servo(1)
	MOVF 0x2D,W
	MOVWF R4H
	MOVF R4H,F
	BTFSC STATUS,Z
	GOTO L0021
	BSF PORTB,5
L0020:
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	DECF R4H,F
	BTFSS STATUS,Z
	GOTO L0020
	BCF PORTB,5
L0021:
; 65: 				WaitMs 9
	MOVLW 0x09
	MOVWF R0L
	CLRF R0H
	CALL W001
; 66: 				Call check_inputs()
	CALL L0001
; 67: 				servo(1) = servo(1) - 1
	MOVLW 0x01
	SUBWF 0x2D,W
	MOVWF 0x2D
; 68: 			Wend
	GOTO L0012
L0013:
; 69: 			While servo(2) > barrier_pos_down 'now left barriers
L0022:
	MOVF 0x2E,W
	SUBLW 0x64
	BTFSC STATUS,C
	GOTO L0023
; 70: 				ServoOut RB6, servo(2) 'so needs to be run twice to get right speed.
	MOVF 0x2E,W
	MOVWF R4H
	MOVF R4H,F
	BTFSC STATUS,Z
	GOTO L0025
	BSF PORTB,6
L0024:
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	DECF R4H,F
	BTFSS STATUS,Z
	GOTO L0024
	BCF PORTB,6
L0025:
; 71: 				ServoOut RB7, servo(2)
	MOVF 0x2E,W
	MOVWF R4H
	MOVF R4H,F
	BTFSC STATUS,Z
	GOTO L0027
	BSF PORTB,7
L0026:
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	DECF R4H,F
	BTFSS STATUS,Z
	GOTO L0026
	BCF PORTB,7
L0027:
; 72: 				WaitMs 9
	MOVLW 0x09
	MOVWF R0L
	CLRF R0H
	CALL W001
; 73: 				Call check_inputs()
	CALL L0001
; 74: 				ServoOut RB6, servo(2) 'so needs to be run twice to get right speed.
	MOVF 0x2E,W
	MOVWF R4H
	MOVF R4H,F
	BTFSC STATUS,Z
	GOTO L0029
	BSF PORTB,6
L0028:
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	DECF R4H,F
	BTFSS STATUS,Z
	GOTO L0028
	BCF PORTB,6
L0029:
; 75: 				ServoOut RB7, servo(2)
	MOVF 0x2E,W
	MOVWF R4H
	MOVF R4H,F
	BTFSC STATUS,Z
	GOTO L0031
	BSF PORTB,7
L0030:
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	DECF R4H,F
	BTFSS STATUS,Z
	GOTO L0030
	BCF PORTB,7
L0031:
; 76: 				WaitMs 9
	MOVLW 0x09
	MOVWF R0L
	CLRF R0H
	CALL W001
; 77: 				Call check_inputs()
	CALL L0001
; 78: 				servo(2) = servo(2) - 1
	MOVLW 0x01
	SUBWF 0x2E,W
	MOVWF 0x2E
; 79: 			Wend
	GOTO L0022
L0023:
; 80: 			action = barrier_down
	MOVLW 0x01
	MOVWF 0x31
; 81: 			Write 1, barrier_pos_down
	MOVLW 0x01
	BSF STATUS,RP0
	MOVWF EEADR
	MOVLW 0x64
	MOVWF EEDATA
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
L0032:	BTFSC EECON1,WR
	GOTO L0032
	BCF EECON1,WREN
	BCF STATUS,RP0
	BCF PIR1,EEIF
; 82: 			Write 2, barrier_pos_down
	MOVLW 0x02
	BSF STATUS,RP0
	MOVWF EEADR
	MOVLW 0x64
	MOVWF EEDATA
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
L0033:	BTFSC EECON1,WR
	GOTO L0033
	BCF EECON1,WREN
	BCF STATUS,RP0
	BCF PIR1,EEIF
; 83: 		Endif
L0011:
; 84: 	Else 'barrier going up
	GOTO L0034
L0010:
; 85: 		If action <> barrier_up Then
	MOVF 0x31,W
	SUBLW 0x00
	BTFSC STATUS,Z
	GOTO L0035
; 86: 			servo(1) = barrier_pos_down
	MOVLW 0x64
	MOVWF 0x2D
; 87: 			servo(2) = barrier_pos_down
	MOVLW 0x64
	MOVWF 0x2E
; 88: 			While servo(1) < barrier_pos_up 'first the right barriers
L0036:
	MOVLW 0xC8
	SUBWF 0x2D,W
	BTFSC STATUS,C
	GOTO L0037
; 89: 				ServoOut RB4, servo(1) 'so needs to be run twice to get right speed.
	MOVF 0x2D,W
	MOVWF R4H
	MOVF R4H,F
	BTFSC STATUS,Z
	GOTO L0039
	BSF PORTB,4
L0038:
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	DECF R4H,F
	BTFSS STATUS,Z
	GOTO L0038
	BCF PORTB,4
L0039:
; 90: 				ServoOut RB5, servo(1)
	MOVF 0x2D,W
	MOVWF R4H
	MOVF R4H,F
	BTFSC STATUS,Z
	GOTO L0041
	BSF PORTB,5
L0040:
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	DECF R4H,F
	BTFSS STATUS,Z
	GOTO L0040
	BCF PORTB,5
L0041:
; 91: 				ServoOut RB6, servo(1) 'so needs to be run twice to get right speed.
	MOVF 0x2D,W
	MOVWF R4H
	MOVF R4H,F
	BTFSC STATUS,Z
	GOTO L0043
	BSF PORTB,6
L0042:
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	DECF R4H,F
	BTFSS STATUS,Z
	GOTO L0042
	BCF PORTB,6
L0043:
; 92: 				ServoOut RB7, servo(1)
	MOVF 0x2D,W
	MOVWF R4H
	MOVF R4H,F
	BTFSC STATUS,Z
	GOTO L0045
	BSF PORTB,7
L0044:
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	DECF R4H,F
	BTFSS STATUS,Z
	GOTO L0044
	BCF PORTB,7
L0045:
; 93: 				WaitMs 8
	MOVLW 0x08
	MOVWF R0L
	CLRF R0H
	CALL W001
; 94: 				Call check_inputs()
	CALL L0001
; 95: 				ServoOut RB4, servo(1) 'so needs to be run twice to get right speed.
	MOVF 0x2D,W
	MOVWF R4H
	MOVF R4H,F
	BTFSC STATUS,Z
	GOTO L0047
	BSF PORTB,4
L0046:
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	DECF R4H,F
	BTFSS STATUS,Z
	GOTO L0046
	BCF PORTB,4
L0047:
; 96: 				ServoOut RB5, servo(1)
	MOVF 0x2D,W
	MOVWF R4H
	MOVF R4H,F
	BTFSC STATUS,Z
	GOTO L0049
	BSF PORTB,5
L0048:
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	DECF R4H,F
	BTFSS STATUS,Z
	GOTO L0048
	BCF PORTB,5
L0049:
; 97: 				ServoOut RB6, servo(1) 'so needs to be run twice to get right speed.
	MOVF 0x2D,W
	MOVWF R4H
	MOVF R4H,F
	BTFSC STATUS,Z
	GOTO L0051
	BSF PORTB,6
L0050:
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	DECF R4H,F
	BTFSS STATUS,Z
	GOTO L0050
	BCF PORTB,6
L0051:
; 98: 				ServoOut RB7, servo(1)
	MOVF 0x2D,W
	MOVWF R4H
	MOVF R4H,F
	BTFSC STATUS,Z
	GOTO L0053
	BSF PORTB,7
L0052:
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	DECF R4H,F
	BTFSS STATUS,Z
	GOTO L0052
	BCF PORTB,7
L0053:
; 99: 				WaitMs 8
	MOVLW 0x08
	MOVWF R0L
	CLRF R0H
	CALL W001
; 100: 				Call check_inputs()
	CALL L0001
; 101: 				servo(1) = servo(1) + 1
	MOVF 0x2D,W
	ADDLW 0x01
	MOVWF 0x2D
; 102: 				servo(2) = servo(2) + 1
	MOVF 0x2E,W
	ADDLW 0x01
	MOVWF 0x2E
; 103: 			Wend
	GOTO L0036
L0037:
; 104: 			action = barrier_up
	CLRF 0x31
; 105: 			Write 1, barrier_pos_up
	MOVLW 0x01
	BSF STATUS,RP0
	MOVWF EEADR
	MOVLW 0xC8
	MOVWF EEDATA
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
L0054:	BTFSC EECON1,WR
	GOTO L0054
	BCF EECON1,WREN
	BCF STATUS,RP0
	BCF PIR1,EEIF
; 106: 			Write 2, barrier_pos_up
	MOVLW 0x02
	BSF STATUS,RP0
	MOVWF EEADR
	MOVLW 0xC8
	MOVWF EEDATA
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
L0055:	BTFSC EECON1,WR
	GOTO L0055
	BCF EECON1,WREN
	BCF STATUS,RP0
	BCF PIR1,EEIF
; 107: 			counter = 0
	CLRF 0x30
; 108: 			While counter < 100
L0056:
	MOVLW 0x64
	SUBWF 0x30,W
	BTFSC STATUS,C
	GOTO L0057
; 109: 				counter = counter + 1
	MOVF 0x30,W
	ADDLW 0x01
	MOVWF 0x30
; 110: 				Call check_inputs()
	CALL L0001
; 111: 				If claim > 0 Then
	MOVF 0x32,W
	SUBLW 0x00
	BTFSC STATUS,C
	GOTO L0058
; 112: 					counter = 101
	MOVLW 0x65
	MOVWF 0x30
; 113: 				Endif
L0058:
; 114: 				WaitMs 10
	MOVLW 0x0A
	MOVWF R0L
	CLRF R0H
	CALL W001
; 115: 				If counter = 100 Then 'skip this when claim has been set again
	MOVF 0x30,W
	SUBLW 0x64
	BTFSS STATUS,Z
	GOTO L0059
; 116: 					red1 = 0 'now the red light off
	BCF 0x05,2
; 117: 					red2 = 0
	BCF 0x05,3
; 118: 				Endif
L0059:
; 119: 			Wend
	GOTO L0056
L0057:
; 120: 		Endif
L0035:
; 121: 	Endif
L0034:
; 122: 
; 123: Wend
	GOTO L0008
L0009:
; 124: End
L0060:	GOTO L0060
; 125: Proc check_inputs()
L0001:
; 126: 	If RA4 = 0 Then '1st input asks for barrier down
	BTFSC 0x05,4
	GOTO L0061
; 127: 		claim.0 = 1
	BSF 0x32,0
; 128: 	Endif
L0061:
; 129: 	If RA6 = 0 Then
	BTFSC 0x05,6
	GOTO L0062
; 130: 		claim.0 = 0 '3rd input asks for barrier up
	BCF 0x32,0
; 131: 	Endif
L0062:
; 132: 	If RA7 = 0 Then '2nd input asks for barrier down
	BTFSC 0x05,7
	GOTO L0063
; 133: 		claim.1 = 1
	BSF 0x32,1
; 134: 	Endif
L0063:
; 135: 	If RB0 = 0 Then
	BTFSC 0x06,0
	GOTO L0064
; 136: 		claim.1 = 0 '4th input asks for barrier up
	BCF 0x32,1
; 137: 	Endif
L0064:
; 138: End Proc
	RETURN
; End of program
L0065:	GOTO L0065
; Waitms Routine
W001:	MOVF R0L,F
	BTFSC STATUS,Z
	GOTO W002
	CALL W003
	DECF R0L,F
	NOP
	NOP
	NOP
	NOP
	NOP
	GOTO W001
W002:	MOVF R0H,F
	BTFSC STATUS,Z
	RETURN
	CALL W003
	DECF R0H,F
	DECF R0L,F
	GOTO W001
W003:	MOVLW 0x0C
	MOVWF R2H
W004:	DECFSZ R2H,F
	GOTO W004
	NOP
	NOP
	MOVLW 0x12
	MOVWF R1L
W005:	DECFSZ R1L,F
	GOTO W006
	CALL W007
	CALL W007
	NOP
	NOP
	RETURN
W006:	CALL W007
	GOTO W005
W007:	MOVLW 0x0D
	MOVWF R2L
W008:	DECFSZ R2L,F
	GOTO W008
	NOP
	RETURN
; Configuration word settings
	ORG 0x2007
	DW 0x3F50
; End of listing
	END
